// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Administrative state. </summary>
    public readonly partial struct NetworkDeviceAdministrativeState : IEquatable<NetworkDeviceAdministrativeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkDeviceAdministrativeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkDeviceAdministrativeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RmaValue = "RMA";
        private const string ResyncValue = "Resync";
        private const string GracefulQuarantineValue = "GracefulQuarantine";
        private const string QuarantineValue = "Quarantine";

        /// <summary> RMA. </summary>
        public static NetworkDeviceAdministrativeState Rma { get; } = new NetworkDeviceAdministrativeState(RmaValue);
        /// <summary> Resync. </summary>
        public static NetworkDeviceAdministrativeState Resync { get; } = new NetworkDeviceAdministrativeState(ResyncValue);
        /// <summary> GracefulQuarantine. </summary>
        public static NetworkDeviceAdministrativeState GracefulQuarantine { get; } = new NetworkDeviceAdministrativeState(GracefulQuarantineValue);
        /// <summary> Quarantine. </summary>
        public static NetworkDeviceAdministrativeState Quarantine { get; } = new NetworkDeviceAdministrativeState(QuarantineValue);
        /// <summary> Determines if two <see cref="NetworkDeviceAdministrativeState"/> values are the same. </summary>
        public static bool operator ==(NetworkDeviceAdministrativeState left, NetworkDeviceAdministrativeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkDeviceAdministrativeState"/> values are not the same. </summary>
        public static bool operator !=(NetworkDeviceAdministrativeState left, NetworkDeviceAdministrativeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkDeviceAdministrativeState"/>. </summary>
        public static implicit operator NetworkDeviceAdministrativeState(string value) => new NetworkDeviceAdministrativeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkDeviceAdministrativeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkDeviceAdministrativeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
