// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> IP Group properties. </summary>
    public partial class MatchConfigurationIPGroupProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MatchConfigurationIPGroupProperties"/>. </summary>
        public MatchConfigurationIPGroupProperties()
        {
            IPPrefixes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MatchConfigurationIPGroupProperties"/>. </summary>
        /// <param name="name"> IP Group name. </param>
        /// <param name="ipAddressType"> IP Address type. </param>
        /// <param name="ipPrefixes"> List of IP Prefixes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MatchConfigurationIPGroupProperties(string name, NetworkFabricIPAddressType? ipAddressType, IList<string> ipPrefixes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IPAddressType = ipAddressType;
            IPPrefixes = ipPrefixes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> IP Group name. </summary>
        public string Name { get; set; }
        /// <summary> IP Address type. </summary>
        public NetworkFabricIPAddressType? IPAddressType { get; set; }
        /// <summary> List of IP Prefixes. </summary>
        public IList<string> IPPrefixes { get; }
    }
}
