// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Common properties for Layer2 Configuration. </summary>
    public partial class Layer2Configuration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="Layer2Configuration"/>. </summary>
        public Layer2Configuration()
        {
            Interfaces = new ChangeTrackingList<ResourceIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="Layer2Configuration"/>. </summary>
        /// <param name="mtu"> MTU of the packets between PE &amp; CE. </param>
        /// <param name="interfaces"> List of network device interfaces resource IDs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal Layer2Configuration(int? mtu, IList<ResourceIdentifier> interfaces, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mtu = mtu;
            Interfaces = interfaces;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> MTU of the packets between PE &amp; CE. </summary>
        public int? Mtu { get; set; }
        /// <summary> List of network device interfaces resource IDs. </summary>
        public IList<ResourceIdentifier> Interfaces { get; }
    }
}
