// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Option B configuration. </summary>
    public partial class L3OptionBProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="L3OptionBProperties"/>. </summary>
        public L3OptionBProperties()
        {
            ImportRouteTargets = new ChangeTrackingList<string>();
            ExportRouteTargets = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="L3OptionBProperties"/>. </summary>
        /// <param name="importRouteTargets"> RouteTargets to be applied. This is used for the backward compatibility. </param>
        /// <param name="exportRouteTargets"> RouteTargets to be applied. This is used for the backward compatibility. </param>
        /// <param name="routeTargets"> RouteTargets to be applied. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal L3OptionBProperties(IList<string> importRouteTargets, IList<string> exportRouteTargets, RouteTargetInformation routeTargets, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ImportRouteTargets = importRouteTargets;
            ExportRouteTargets = exportRouteTargets;
            RouteTargets = routeTargets;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> RouteTargets to be applied. This is used for the backward compatibility. </summary>
        public IList<string> ImportRouteTargets { get; }
        /// <summary> RouteTargets to be applied. This is used for the backward compatibility. </summary>
        public IList<string> ExportRouteTargets { get; }
        /// <summary> RouteTargets to be applied. </summary>
        public RouteTargetInformation RouteTargets { get; set; }
    }
}
