// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> To check whether monitoring of internal network is enabled or not. </summary>
    public readonly partial struct IsMonitoringEnabled : IEquatable<IsMonitoringEnabled>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IsMonitoringEnabled"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IsMonitoringEnabled(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static IsMonitoringEnabled True { get; } = new IsMonitoringEnabled(TrueValue);
        /// <summary> False. </summary>
        public static IsMonitoringEnabled False { get; } = new IsMonitoringEnabled(FalseValue);
        /// <summary> Determines if two <see cref="IsMonitoringEnabled"/> values are the same. </summary>
        public static bool operator ==(IsMonitoringEnabled left, IsMonitoringEnabled right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IsMonitoringEnabled"/> values are not the same. </summary>
        public static bool operator !=(IsMonitoringEnabled left, IsMonitoringEnabled right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IsMonitoringEnabled"/>. </summary>
        public static implicit operator IsMonitoringEnabled(string value) => new IsMonitoringEnabled(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IsMonitoringEnabled other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IsMonitoringEnabled other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
