// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    public partial class InternalNetworkBgpConfiguration : IUtf8JsonSerializable, IJsonModel<InternalNetworkBgpConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InternalNetworkBgpConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InternalNetworkBgpConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalNetworkBgpConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalNetworkBgpConfiguration)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        InternalNetworkBgpConfiguration IJsonModel<InternalNetworkBgpConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalNetworkBgpConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalNetworkBgpConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInternalNetworkBgpConfiguration(document.RootElement, options);
        }

        internal static InternalNetworkBgpConfiguration DeserializeInternalNetworkBgpConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BfdConfiguration bfdConfiguration = default;
            NetworkFabricBooleanValue? defaultRouteOriginate = default;
            int? allowAS = default;
            AllowASOverride? allowASOverride = default;
            long? fabricAsn = default;
            long? peerAsn = default;
            IList<string> ipv4ListenRangePrefixes = default;
            IList<string> ipv6ListenRangePrefixes = default;
            IList<NeighborAddress> ipv4NeighborAddress = default;
            IList<NeighborAddress> ipv6NeighborAddress = default;
            string annotation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("bfdConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bfdConfiguration = BfdConfiguration.DeserializeBfdConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("defaultRouteOriginate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    defaultRouteOriginate = new NetworkFabricBooleanValue(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("allowAS"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowAS = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allowASOverride"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowASOverride = new AllowASOverride(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("fabricASN"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fabricAsn = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("peerASN"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    peerAsn = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("ipv4ListenRangePrefixes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ipv4ListenRangePrefixes = array;
                    continue;
                }
                if (property.NameEquals("ipv6ListenRangePrefixes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ipv6ListenRangePrefixes = array;
                    continue;
                }
                if (property.NameEquals("ipv4NeighborAddress"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<NeighborAddress> array = new List<NeighborAddress>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(NeighborAddress.DeserializeNeighborAddress(item, options));
                    }
                    ipv4NeighborAddress = array;
                    continue;
                }
                if (property.NameEquals("ipv6NeighborAddress"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<NeighborAddress> array = new List<NeighborAddress>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(NeighborAddress.DeserializeNeighborAddress(item, options));
                    }
                    ipv6NeighborAddress = array;
                    continue;
                }
                if (property.NameEquals("annotation"u8))
                {
                    annotation = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InternalNetworkBgpConfiguration(
                annotation,
                serializedAdditionalRawData,
                bfdConfiguration,
                defaultRouteOriginate,
                allowAS,
                allowASOverride,
                fabricAsn,
                peerAsn,
                ipv4ListenRangePrefixes ?? new ChangeTrackingList<string>(),
                ipv6ListenRangePrefixes ?? new ChangeTrackingList<string>(),
                ipv4NeighborAddress ?? new ChangeTrackingList<NeighborAddress>(),
                ipv6NeighborAddress ?? new ChangeTrackingList<NeighborAddress>());
        }

        BinaryData IPersistableModel<InternalNetworkBgpConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalNetworkBgpConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InternalNetworkBgpConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        InternalNetworkBgpConfiguration IPersistableModel<InternalNetworkBgpConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalNetworkBgpConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInternalNetworkBgpConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InternalNetworkBgpConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InternalNetworkBgpConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
