// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Specify prefix-list bounds. </summary>
    public readonly partial struct IPPrefixRuleCondition : IEquatable<IPPrefixRuleCondition>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IPPrefixRuleCondition"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IPPrefixRuleCondition(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualToValue = "EqualTo";
        private const string GreaterThanOrEqualToValue = "GreaterThanOrEqualTo";
        private const string LesserThanOrEqualToValue = "LesserThanOrEqualTo";
        private const string RangeValue = "Range";

        /// <summary> EqualTo. </summary>
        public static IPPrefixRuleCondition EqualTo { get; } = new IPPrefixRuleCondition(EqualToValue);
        /// <summary> GreaterThanOrEqualTo. </summary>
        public static IPPrefixRuleCondition GreaterThanOrEqualTo { get; } = new IPPrefixRuleCondition(GreaterThanOrEqualToValue);
        /// <summary> LesserThanOrEqualTo. </summary>
        public static IPPrefixRuleCondition LesserThanOrEqualTo { get; } = new IPPrefixRuleCondition(LesserThanOrEqualToValue);
        /// <summary> Range. </summary>
        public static IPPrefixRuleCondition Range { get; } = new IPPrefixRuleCondition(RangeValue);
        /// <summary> Determines if two <see cref="IPPrefixRuleCondition"/> values are the same. </summary>
        public static bool operator ==(IPPrefixRuleCondition left, IPPrefixRuleCondition right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IPPrefixRuleCondition"/> values are not the same. </summary>
        public static bool operator !=(IPPrefixRuleCondition left, IPPrefixRuleCondition right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IPPrefixRuleCondition"/>. </summary>
        public static implicit operator IPPrefixRuleCondition(string value) => new IPPrefixRuleCondition(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IPPrefixRuleCondition other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IPPrefixRuleCondition other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
