// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> IP Community patchable properties. </summary>
    public partial class IPCommunityRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IPCommunityRule"/>. </summary>
        /// <param name="action"> Action to be taken on the configuration. Example: Permit | Deny. </param>
        /// <param name="sequenceNumber"> Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored. </param>
        /// <param name="communityMembers"> List the community members of IP Community. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="communityMembers"/> is null. </exception>
        public IPCommunityRule(CommunityActionType action, long sequenceNumber, IEnumerable<string> communityMembers)
        {
            Argument.AssertNotNull(communityMembers, nameof(communityMembers));

            Action = action;
            SequenceNumber = sequenceNumber;
            WellKnownCommunities = new ChangeTrackingList<WellKnownCommunity>();
            CommunityMembers = communityMembers.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="IPCommunityRule"/>. </summary>
        /// <param name="action"> Action to be taken on the configuration. Example: Permit | Deny. </param>
        /// <param name="sequenceNumber"> Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored. </param>
        /// <param name="wellKnownCommunities"> Supported well known Community List. </param>
        /// <param name="communityMembers"> List the community members of IP Community. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IPCommunityRule(CommunityActionType action, long sequenceNumber, IList<WellKnownCommunity> wellKnownCommunities, IList<string> communityMembers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Action = action;
            SequenceNumber = sequenceNumber;
            WellKnownCommunities = wellKnownCommunities;
            CommunityMembers = communityMembers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IPCommunityRule"/> for deserialization. </summary>
        internal IPCommunityRule()
        {
        }

        /// <summary> Action to be taken on the configuration. Example: Permit | Deny. </summary>
        public CommunityActionType Action { get; set; }
        /// <summary> Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored. </summary>
        public long SequenceNumber { get; set; }
        /// <summary> Supported well known Community List. </summary>
        public IList<WellKnownCommunity> WellKnownCommunities { get; }
        /// <summary> List the community members of IP Community. </summary>
        public IList<string> CommunityMembers { get; }
    }
}
