// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> IP Community add operation properties. </summary>
    public partial class IPCommunityAddOperationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IPCommunityAddOperationProperties"/>. </summary>
        public IPCommunityAddOperationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IPCommunityAddOperationProperties"/>. </summary>
        /// <param name="add"> List of IP Community IDs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IPCommunityAddOperationProperties(IPCommunityIdList @add, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Add = @add;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of IP Community IDs. </summary>
        internal IPCommunityIdList Add { get; set; }
        /// <summary> List of IP Community resource IDs. </summary>
        public IList<ResourceIdentifier> AddIPCommunityIds
        {
            get
            {
                if (Add is null)
                    Add = new IPCommunityIdList();
                return Add.IPCommunityIds;
            }
        }
    }
}
