// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Connected Subnet Route Policy properties. </summary>
    public partial class ConnectedSubnetRoutePolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectedSubnetRoutePolicy"/>. </summary>
        public ConnectedSubnetRoutePolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectedSubnetRoutePolicy"/>. </summary>
        /// <param name="exportRoutePolicyId"> ARM Resource ID of the Route Policy. This is used for the backward compatibility. </param>
        /// <param name="exportRoutePolicy"> Array of ARM Resource ID of the RoutePolicies. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectedSubnetRoutePolicy(ResourceIdentifier exportRoutePolicyId, L3ExportRoutePolicy exportRoutePolicy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExportRoutePolicyId = exportRoutePolicyId;
            ExportRoutePolicy = exportRoutePolicy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ARM Resource ID of the Route Policy. This is used for the backward compatibility. </summary>
        public ResourceIdentifier ExportRoutePolicyId { get; set; }
        /// <summary> Array of ARM Resource ID of the RoutePolicies. </summary>
        public L3ExportRoutePolicy ExportRoutePolicy { get; set; }
    }
}
