// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> community action types. Example: Permit | Deny. </summary>
    public readonly partial struct CommunityActionType : IEquatable<CommunityActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CommunityActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CommunityActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PermitValue = "Permit";
        private const string DenyValue = "Deny";

        /// <summary> Permit. </summary>
        public static CommunityActionType Permit { get; } = new CommunityActionType(PermitValue);
        /// <summary> Deny. </summary>
        public static CommunityActionType Deny { get; } = new CommunityActionType(DenyValue);
        /// <summary> Determines if two <see cref="CommunityActionType"/> values are the same. </summary>
        public static bool operator ==(CommunityActionType left, CommunityActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CommunityActionType"/> values are not the same. </summary>
        public static bool operator !=(CommunityActionType left, CommunityActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CommunityActionType"/>. </summary>
        public static implicit operator CommunityActionType(string value) => new CommunityActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CommunityActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CommunityActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
