// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Administrative state of the BfdConfiguration. Example: Enabled | Disabled. </summary>
    public readonly partial struct BfdAdministrativeState : IEquatable<BfdAdministrativeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BfdAdministrativeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BfdAdministrativeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string MatValue = "MAT";
        private const string RmaValue = "RMA";

        /// <summary> Enabled. </summary>
        public static BfdAdministrativeState Enabled { get; } = new BfdAdministrativeState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static BfdAdministrativeState Disabled { get; } = new BfdAdministrativeState(DisabledValue);
        /// <summary> MAT. </summary>
        public static BfdAdministrativeState Mat { get; } = new BfdAdministrativeState(MatValue);
        /// <summary> RMA. </summary>
        public static BfdAdministrativeState Rma { get; } = new BfdAdministrativeState(RmaValue);
        /// <summary> Determines if two <see cref="BfdAdministrativeState"/> values are the same. </summary>
        public static bool operator ==(BfdAdministrativeState left, BfdAdministrativeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BfdAdministrativeState"/> values are not the same. </summary>
        public static bool operator !=(BfdAdministrativeState left, BfdAdministrativeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BfdAdministrativeState"/>. </summary>
        public static implicit operator BfdAdministrativeState(string value) => new BfdAdministrativeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BfdAdministrativeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BfdAdministrativeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
