// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> AddressFamilyType. This parameter decides whether the given ipv4 or ipv6 route policy. </summary>
    public readonly partial struct AddressFamilyType : IEquatable<AddressFamilyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AddressFamilyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AddressFamilyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPv4Value = "IPv4";
        private const string IPv6Value = "IPv6";

        /// <summary> IPv4. </summary>
        public static AddressFamilyType IPv4 { get; } = new AddressFamilyType(IPv4Value);
        /// <summary> IPv6. </summary>
        public static AddressFamilyType IPv6 { get; } = new AddressFamilyType(IPv6Value);
        /// <summary> Determines if two <see cref="AddressFamilyType"/> values are the same. </summary>
        public static bool operator ==(AddressFamilyType left, AddressFamilyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AddressFamilyType"/> values are not the same. </summary>
        public static bool operator !=(AddressFamilyType left, AddressFamilyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AddressFamilyType"/>. </summary>
        public static implicit operator AddressFamilyType(string value) => new AddressFamilyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AddressFamilyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AddressFamilyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
