// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Type of actions that can be performed. </summary>
    public readonly partial struct AclActionType : IEquatable<AclActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AclActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AclActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DropValue = "Drop";
        private const string CountValue = "Count";
        private const string LogValue = "Log";

        /// <summary> Drop. </summary>
        public static AclActionType Drop { get; } = new AclActionType(DropValue);
        /// <summary> Count. </summary>
        public static AclActionType Count { get; } = new AclActionType(CountValue);
        /// <summary> Log. </summary>
        public static AclActionType Log { get; } = new AclActionType(LogValue);
        /// <summary> Determines if two <see cref="AclActionType"/> values are the same. </summary>
        public static bool operator ==(AclActionType left, AclActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AclActionType"/> values are not the same. </summary>
        public static bool operator !=(AclActionType left, AclActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AclActionType"/>. </summary>
        public static implicit operator AclActionType(string value) => new AclActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AclActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AclActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
