// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Defines the match condition that is supported to filter the traffic. </summary>
    public partial class AccessControlListMatchCondition : CommonMatchConditions
    {
        /// <summary> Initializes a new instance of <see cref="AccessControlListMatchCondition"/>. </summary>
        public AccessControlListMatchCondition()
        {
            EtherTypes = new ChangeTrackingList<string>();
            Fragments = new ChangeTrackingList<string>();
            IPLengths = new ChangeTrackingList<string>();
            TtlValues = new ChangeTrackingList<string>();
            DscpMarkings = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AccessControlListMatchCondition"/>. </summary>
        /// <param name="protocolTypes"> List of the protocols that need to be matched. </param>
        /// <param name="vlanMatchCondition"> Vlan match condition that needs to be matched. </param>
        /// <param name="ipCondition"> IP condition that needs to be matched. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etherTypes"> List of ether type values that need to be matched. </param>
        /// <param name="fragments"> List of IP fragment packets that need to be matched. </param>
        /// <param name="ipLengths"> List of IP Lengths that need to be matched. </param>
        /// <param name="ttlValues"> List of TTL [Time To Live] values that need to be matched. </param>
        /// <param name="dscpMarkings"> List of DSCP Markings that need to be matched. </param>
        /// <param name="portCondition"> Defines the port condition that needs to be matched. </param>
        internal AccessControlListMatchCondition(IList<string> protocolTypes, VlanMatchCondition vlanMatchCondition, IPMatchCondition ipCondition, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<string> etherTypes, IList<string> fragments, IList<string> ipLengths, IList<string> ttlValues, IList<string> dscpMarkings, AccessControlListPortCondition portCondition) : base(protocolTypes, vlanMatchCondition, ipCondition, serializedAdditionalRawData)
        {
            EtherTypes = etherTypes;
            Fragments = fragments;
            IPLengths = ipLengths;
            TtlValues = ttlValues;
            DscpMarkings = dscpMarkings;
            PortCondition = portCondition;
        }

        /// <summary> List of ether type values that need to be matched. </summary>
        public IList<string> EtherTypes { get; }
        /// <summary> List of IP fragment packets that need to be matched. </summary>
        public IList<string> Fragments { get; }
        /// <summary> List of IP Lengths that need to be matched. </summary>
        public IList<string> IPLengths { get; }
        /// <summary> List of TTL [Time To Live] values that need to be matched. </summary>
        public IList<string> TtlValues { get; }
        /// <summary> List of DSCP Markings that need to be matched. </summary>
        public IList<string> DscpMarkings { get; }
        /// <summary> Defines the port condition that needs to be matched. </summary>
        public AccessControlListPortCondition PortCondition { get; set; }
    }
}
