// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    public partial class AccessControlListMatchCondition : IUtf8JsonSerializable, IJsonModel<AccessControlListMatchCondition>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AccessControlListMatchCondition>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AccessControlListMatchCondition>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessControlListMatchCondition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AccessControlListMatchCondition)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(EtherTypes))
            {
                writer.WritePropertyName("etherTypes"u8);
                writer.WriteStartArray();
                foreach (var item in EtherTypes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Fragments))
            {
                writer.WritePropertyName("fragments"u8);
                writer.WriteStartArray();
                foreach (var item in Fragments)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IPLengths))
            {
                writer.WritePropertyName("ipLengths"u8);
                writer.WriteStartArray();
                foreach (var item in IPLengths)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TtlValues))
            {
                writer.WritePropertyName("ttlValues"u8);
                writer.WriteStartArray();
                foreach (var item in TtlValues)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DscpMarkings))
            {
                writer.WritePropertyName("dscpMarkings"u8);
                writer.WriteStartArray();
                foreach (var item in DscpMarkings)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PortCondition))
            {
                writer.WritePropertyName("portCondition"u8);
                writer.WriteObjectValue(PortCondition, options);
            }
        }

        AccessControlListMatchCondition IJsonModel<AccessControlListMatchCondition>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessControlListMatchCondition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AccessControlListMatchCondition)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAccessControlListMatchCondition(document.RootElement, options);
        }

        internal static AccessControlListMatchCondition DeserializeAccessControlListMatchCondition(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<string> etherTypes = default;
            IList<string> fragments = default;
            IList<string> ipLengths = default;
            IList<string> ttlValues = default;
            IList<string> dscpMarkings = default;
            AccessControlListPortCondition portCondition = default;
            IList<string> protocolTypes = default;
            VlanMatchCondition vlanMatchCondition = default;
            IPMatchCondition ipCondition = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etherTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    etherTypes = array;
                    continue;
                }
                if (property.NameEquals("fragments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    fragments = array;
                    continue;
                }
                if (property.NameEquals("ipLengths"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ipLengths = array;
                    continue;
                }
                if (property.NameEquals("ttlValues"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ttlValues = array;
                    continue;
                }
                if (property.NameEquals("dscpMarkings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    dscpMarkings = array;
                    continue;
                }
                if (property.NameEquals("portCondition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    portCondition = AccessControlListPortCondition.DeserializeAccessControlListPortCondition(property.Value, options);
                    continue;
                }
                if (property.NameEquals("protocolTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    protocolTypes = array;
                    continue;
                }
                if (property.NameEquals("vlanMatchCondition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vlanMatchCondition = VlanMatchCondition.DeserializeVlanMatchCondition(property.Value, options);
                    continue;
                }
                if (property.NameEquals("ipCondition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ipCondition = IPMatchCondition.DeserializeIPMatchCondition(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AccessControlListMatchCondition(
                protocolTypes ?? new ChangeTrackingList<string>(),
                vlanMatchCondition,
                ipCondition,
                serializedAdditionalRawData,
                etherTypes ?? new ChangeTrackingList<string>(),
                fragments ?? new ChangeTrackingList<string>(),
                ipLengths ?? new ChangeTrackingList<string>(),
                ttlValues ?? new ChangeTrackingList<string>(),
                dscpMarkings ?? new ChangeTrackingList<string>(),
                portCondition);
        }

        BinaryData IPersistableModel<AccessControlListMatchCondition>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessControlListMatchCondition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AccessControlListMatchCondition)} does not support writing '{options.Format}' format.");
            }
        }

        AccessControlListMatchCondition IPersistableModel<AccessControlListMatchCondition>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessControlListMatchCondition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAccessControlListMatchCondition(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AccessControlListMatchCondition)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AccessControlListMatchCondition>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
