// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkTapOperationSource : IOperationSource<NetworkTapResource>
    {
        private readonly ArmClient _client;

        internal NetworkTapOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkTapResource IOperationSource<NetworkTapResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkTapData.DeserializeNetworkTapData(document.RootElement);
            return new NetworkTapResource(_client, data);
        }

        async ValueTask<NetworkTapResource> IOperationSource<NetworkTapResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkTapData.DeserializeNetworkTapData(document.RootElement);
            return new NetworkTapResource(_client, data);
        }
    }
}
