// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkRackOperationSource : IOperationSource<NetworkRackResource>
    {
        private readonly ArmClient _client;

        internal NetworkRackOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkRackResource IOperationSource<NetworkRackResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkRackData.DeserializeNetworkRackData(document.RootElement);
            return new NetworkRackResource(_client, data);
        }

        async ValueTask<NetworkRackResource> IOperationSource<NetworkRackResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkRackData.DeserializeNetworkRackData(document.RootElement);
            return new NetworkRackResource(_client, data);
        }
    }
}
