// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkFabricRoutePolicyOperationSource : IOperationSource<NetworkFabricRoutePolicyResource>
    {
        private readonly ArmClient _client;

        internal NetworkFabricRoutePolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkFabricRoutePolicyResource IOperationSource<NetworkFabricRoutePolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkFabricRoutePolicyData.DeserializeNetworkFabricRoutePolicyData(document.RootElement);
            return new NetworkFabricRoutePolicyResource(_client, data);
        }

        async ValueTask<NetworkFabricRoutePolicyResource> IOperationSource<NetworkFabricRoutePolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkFabricRoutePolicyData.DeserializeNetworkFabricRoutePolicyData(document.RootElement);
            return new NetworkFabricRoutePolicyResource(_client, data);
        }
    }
}
