// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkFabricExternalNetworkOperationSource : IOperationSource<NetworkFabricExternalNetworkResource>
    {
        private readonly ArmClient _client;

        internal NetworkFabricExternalNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkFabricExternalNetworkResource IOperationSource<NetworkFabricExternalNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkFabricExternalNetworkData.DeserializeNetworkFabricExternalNetworkData(document.RootElement);
            return new NetworkFabricExternalNetworkResource(_client, data);
        }

        async ValueTask<NetworkFabricExternalNetworkResource> IOperationSource<NetworkFabricExternalNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkFabricExternalNetworkData.DeserializeNetworkFabricExternalNetworkData(document.RootElement);
            return new NetworkFabricExternalNetworkResource(_client, data);
        }
    }
}
