// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkFabricControllerOperationSource : IOperationSource<NetworkFabricControllerResource>
    {
        private readonly ArmClient _client;

        internal NetworkFabricControllerOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkFabricControllerResource IOperationSource<NetworkFabricControllerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkFabricControllerData.DeserializeNetworkFabricControllerData(document.RootElement);
            return new NetworkFabricControllerResource(_client, data);
        }

        async ValueTask<NetworkFabricControllerResource> IOperationSource<NetworkFabricControllerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkFabricControllerData.DeserializeNetworkFabricControllerData(document.RootElement);
            return new NetworkFabricControllerResource(_client, data);
        }
    }
}
