// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkFabricAccessControlListOperationSource : IOperationSource<NetworkFabricAccessControlListResource>
    {
        private readonly ArmClient _client;

        internal NetworkFabricAccessControlListOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkFabricAccessControlListResource IOperationSource<NetworkFabricAccessControlListResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkFabricAccessControlListData.DeserializeNetworkFabricAccessControlListData(document.RootElement);
            return new NetworkFabricAccessControlListResource(_client, data);
        }

        async ValueTask<NetworkFabricAccessControlListResource> IOperationSource<NetworkFabricAccessControlListResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkFabricAccessControlListData.DeserializeNetworkFabricAccessControlListData(document.RootElement);
            return new NetworkFabricAccessControlListResource(_client, data);
        }
    }
}
