// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric
{
    internal class NetworkDeviceInterfaceOperationSource : IOperationSource<NetworkDeviceInterfaceResource>
    {
        private readonly ArmClient _client;

        internal NetworkDeviceInterfaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetworkDeviceInterfaceResource IOperationSource<NetworkDeviceInterfaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkDeviceInterfaceData.DeserializeNetworkDeviceInterfaceData(document.RootElement);
            return new NetworkDeviceInterfaceResource(_client, data);
        }

        async ValueTask<NetworkDeviceInterfaceResource> IOperationSource<NetworkDeviceInterfaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkDeviceInterfaceData.DeserializeNetworkDeviceInterfaceData(document.RootElement);
            return new NetworkDeviceInterfaceResource(_client, data);
        }
    }
}
