// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ManagedNetworkFabric.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableManagedNetworkFabricArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableManagedNetworkFabricArmClient"/> class for mocking. </summary>
        protected MockableManagedNetworkFabricArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableManagedNetworkFabricArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableManagedNetworkFabricArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableManagedNetworkFabricArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricAccessControlListResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricAccessControlListResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricAccessControlListResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricAccessControlListResource"/> object. </returns>
        public virtual NetworkFabricAccessControlListResource GetNetworkFabricAccessControlListResource(ResourceIdentifier id)
        {
            NetworkFabricAccessControlListResource.ValidateResourceId(id);
            return new NetworkFabricAccessControlListResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricInternetGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricInternetGatewayResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricInternetGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricInternetGatewayResource"/> object. </returns>
        public virtual NetworkFabricInternetGatewayResource GetNetworkFabricInternetGatewayResource(ResourceIdentifier id)
        {
            NetworkFabricInternetGatewayResource.ValidateResourceId(id);
            return new NetworkFabricInternetGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricInternetGatewayRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricInternetGatewayRuleResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricInternetGatewayRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricInternetGatewayRuleResource"/> object. </returns>
        public virtual NetworkFabricInternetGatewayRuleResource GetNetworkFabricInternetGatewayRuleResource(ResourceIdentifier id)
        {
            NetworkFabricInternetGatewayRuleResource.ValidateResourceId(id);
            return new NetworkFabricInternetGatewayRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricIPCommunityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricIPCommunityResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricIPCommunityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricIPCommunityResource"/> object. </returns>
        public virtual NetworkFabricIPCommunityResource GetNetworkFabricIPCommunityResource(ResourceIdentifier id)
        {
            NetworkFabricIPCommunityResource.ValidateResourceId(id);
            return new NetworkFabricIPCommunityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricIPExtendedCommunityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricIPExtendedCommunityResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricIPExtendedCommunityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricIPExtendedCommunityResource"/> object. </returns>
        public virtual NetworkFabricIPExtendedCommunityResource GetNetworkFabricIPExtendedCommunityResource(ResourceIdentifier id)
        {
            NetworkFabricIPExtendedCommunityResource.ValidateResourceId(id);
            return new NetworkFabricIPExtendedCommunityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricIPPrefixResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricIPPrefixResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricIPPrefixResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricIPPrefixResource"/> object. </returns>
        public virtual NetworkFabricIPPrefixResource GetNetworkFabricIPPrefixResource(ResourceIdentifier id)
        {
            NetworkFabricIPPrefixResource.ValidateResourceId(id);
            return new NetworkFabricIPPrefixResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricL2IsolationDomainResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricL2IsolationDomainResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricL2IsolationDomainResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricL2IsolationDomainResource"/> object. </returns>
        public virtual NetworkFabricL2IsolationDomainResource GetNetworkFabricL2IsolationDomainResource(ResourceIdentifier id)
        {
            NetworkFabricL2IsolationDomainResource.ValidateResourceId(id);
            return new NetworkFabricL2IsolationDomainResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricL3IsolationDomainResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricL3IsolationDomainResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricL3IsolationDomainResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricL3IsolationDomainResource"/> object. </returns>
        public virtual NetworkFabricL3IsolationDomainResource GetNetworkFabricL3IsolationDomainResource(ResourceIdentifier id)
        {
            NetworkFabricL3IsolationDomainResource.ValidateResourceId(id);
            return new NetworkFabricL3IsolationDomainResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricInternalNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricInternalNetworkResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricInternalNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricInternalNetworkResource"/> object. </returns>
        public virtual NetworkFabricInternalNetworkResource GetNetworkFabricInternalNetworkResource(ResourceIdentifier id)
        {
            NetworkFabricInternalNetworkResource.ValidateResourceId(id);
            return new NetworkFabricInternalNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricExternalNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricExternalNetworkResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricExternalNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricExternalNetworkResource"/> object. </returns>
        public virtual NetworkFabricExternalNetworkResource GetNetworkFabricExternalNetworkResource(ResourceIdentifier id)
        {
            NetworkFabricExternalNetworkResource.ValidateResourceId(id);
            return new NetworkFabricExternalNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricNeighborGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricNeighborGroupResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricNeighborGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricNeighborGroupResource"/> object. </returns>
        public virtual NetworkFabricNeighborGroupResource GetNetworkFabricNeighborGroupResource(ResourceIdentifier id)
        {
            NetworkFabricNeighborGroupResource.ValidateResourceId(id);
            return new NetworkFabricNeighborGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkDeviceSkuResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkDeviceSkuResource.CreateResourceIdentifier" /> to create a <see cref="NetworkDeviceSkuResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkDeviceSkuResource"/> object. </returns>
        public virtual NetworkDeviceSkuResource GetNetworkDeviceSkuResource(ResourceIdentifier id)
        {
            NetworkDeviceSkuResource.ValidateResourceId(id);
            return new NetworkDeviceSkuResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkDeviceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkDeviceResource.CreateResourceIdentifier" /> to create a <see cref="NetworkDeviceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkDeviceResource"/> object. </returns>
        public virtual NetworkDeviceResource GetNetworkDeviceResource(ResourceIdentifier id)
        {
            NetworkDeviceResource.ValidateResourceId(id);
            return new NetworkDeviceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkDeviceInterfaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkDeviceInterfaceResource.CreateResourceIdentifier" /> to create a <see cref="NetworkDeviceInterfaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkDeviceInterfaceResource"/> object. </returns>
        public virtual NetworkDeviceInterfaceResource GetNetworkDeviceInterfaceResource(ResourceIdentifier id)
        {
            NetworkDeviceInterfaceResource.ValidateResourceId(id);
            return new NetworkDeviceInterfaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricControllerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricControllerResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricControllerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricControllerResource"/> object. </returns>
        public virtual NetworkFabricControllerResource GetNetworkFabricControllerResource(ResourceIdentifier id)
        {
            NetworkFabricControllerResource.ValidateResourceId(id);
            return new NetworkFabricControllerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricSkuResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricSkuResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricSkuResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricSkuResource"/> object. </returns>
        public virtual NetworkFabricSkuResource GetNetworkFabricSkuResource(ResourceIdentifier id)
        {
            NetworkFabricSkuResource.ValidateResourceId(id);
            return new NetworkFabricSkuResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricResource"/> object. </returns>
        public virtual NetworkFabricResource GetNetworkFabricResource(ResourceIdentifier id)
        {
            NetworkFabricResource.ValidateResourceId(id);
            return new NetworkFabricResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkToNetworkInterconnectResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkToNetworkInterconnectResource.CreateResourceIdentifier" /> to create a <see cref="NetworkToNetworkInterconnectResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkToNetworkInterconnectResource"/> object. </returns>
        public virtual NetworkToNetworkInterconnectResource GetNetworkToNetworkInterconnectResource(ResourceIdentifier id)
        {
            NetworkToNetworkInterconnectResource.ValidateResourceId(id);
            return new NetworkToNetworkInterconnectResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkPacketBrokerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkPacketBrokerResource.CreateResourceIdentifier" /> to create a <see cref="NetworkPacketBrokerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkPacketBrokerResource"/> object. </returns>
        public virtual NetworkPacketBrokerResource GetNetworkPacketBrokerResource(ResourceIdentifier id)
        {
            NetworkPacketBrokerResource.ValidateResourceId(id);
            return new NetworkPacketBrokerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkRackResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkRackResource.CreateResourceIdentifier" /> to create a <see cref="NetworkRackResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkRackResource"/> object. </returns>
        public virtual NetworkRackResource GetNetworkRackResource(ResourceIdentifier id)
        {
            NetworkRackResource.ValidateResourceId(id);
            return new NetworkRackResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkTapRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkTapRuleResource.CreateResourceIdentifier" /> to create a <see cref="NetworkTapRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkTapRuleResource"/> object. </returns>
        public virtual NetworkTapRuleResource GetNetworkTapRuleResource(ResourceIdentifier id)
        {
            NetworkTapRuleResource.ValidateResourceId(id);
            return new NetworkTapRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkTapResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkTapResource.CreateResourceIdentifier" /> to create a <see cref="NetworkTapResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkTapResource"/> object. </returns>
        public virtual NetworkTapResource GetNetworkTapResource(ResourceIdentifier id)
        {
            NetworkTapResource.ValidateResourceId(id);
            return new NetworkTapResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="NetworkFabricRoutePolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="NetworkFabricRoutePolicyResource.CreateResourceIdentifier" /> to create a <see cref="NetworkFabricRoutePolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="NetworkFabricRoutePolicyResource"/> object. </returns>
        public virtual NetworkFabricRoutePolicyResource GetNetworkFabricRoutePolicyResource(ResourceIdentifier id)
        {
            NetworkFabricRoutePolicyResource.ValidateResourceId(id);
            return new NetworkFabricRoutePolicyResource(Client, id);
        }
    }
}
