// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ManagedNetworkFabric.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmManagedNetworkFabricModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricAccessControlListData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="configurationType"> Input method to configure Access Control List. </param>
        /// <param name="aclsUri"> Access Control List file URL. </param>
        /// <param name="defaultAction"> Default action that needs to be applied when no condition is matched. Example: Permit | Deny. </param>
        /// <param name="matchConfigurations"> List of match configurations. </param>
        /// <param name="dynamicMatchConfigurations"> List of dynamic match configurations. </param>
        /// <param name="lastSyncedOn"> The last synced timestamp. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricAccessControlListData"/> instance for mocking. </returns>
        public static NetworkFabricAccessControlListData NetworkFabricAccessControlListData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, NetworkFabricConfigurationType? configurationType = null, Uri aclsUri = null, CommunityActionType? defaultAction = null, IEnumerable<AccessControlListMatchConfiguration> matchConfigurations = null, IEnumerable<CommonDynamicMatchConfiguration> dynamicMatchConfigurations = null, DateTimeOffset? lastSyncedOn = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            matchConfigurations ??= new List<AccessControlListMatchConfiguration>();
            dynamicMatchConfigurations ??= new List<CommonDynamicMatchConfiguration>();

            return new NetworkFabricAccessControlListData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                configurationType,
                aclsUri,
                defaultAction,
                matchConfigurations?.ToList(),
                dynamicMatchConfigurations?.ToList(),
                lastSyncedOn,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkFabricErrorResult"/>. </summary>
        /// <param name="error"> The error object. </param>
        /// <returns> A new <see cref="Models.NetworkFabricErrorResult"/> instance for mocking. </returns>
        public static NetworkFabricErrorResult NetworkFabricErrorResult(ResponseError error = null)
        {
            return new NetworkFabricErrorResult(error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StateUpdateCommonPostActionResult"/>. </summary>
        /// <param name="error"> The error object. </param>
        /// <param name="configurationState"> Gets the configuration state. </param>
        /// <returns> A new <see cref="Models.StateUpdateCommonPostActionResult"/> instance for mocking. </returns>
        public static StateUpdateCommonPostActionResult StateUpdateCommonPostActionResult(ResponseError error = null, NetworkFabricConfigurationState? configurationState = null)
        {
            return new StateUpdateCommonPostActionResult(error, serializedAdditionalRawData: null, configurationState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateConfigurationResult"/>. </summary>
        /// <param name="error"> The error object. </param>
        /// <param name="configurationState"> Gets the configuration state. </param>
        /// <param name="uri"> URL for the details of the response. </param>
        /// <returns> A new <see cref="Models.ValidateConfigurationResult"/> instance for mocking. </returns>
        public static ValidateConfigurationResult ValidateConfigurationResult(ResponseError error = null, NetworkFabricConfigurationState? configurationState = null, Uri uri = null)
        {
            return new ValidateConfigurationResult(error, serializedAdditionalRawData: null, configurationState, uri);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricInternetGatewayData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="internetGatewayRuleId"> ARM Resource ID of the Internet Gateway Rule. </param>
        /// <param name="ipV4Address"> IPv4 Address of Internet Gateway. </param>
        /// <param name="port"> Port number of Internet Gateway. </param>
        /// <param name="typePropertiesType"> Gateway Type of the resource. </param>
        /// <param name="networkFabricControllerId"> ARM Resource ID of the Network Fabric Controller. </param>
        /// <param name="provisioningState"> Provisioning state of resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricInternetGatewayData"/> instance for mocking. </returns>
        public static NetworkFabricInternetGatewayData NetworkFabricInternetGatewayData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, ResourceIdentifier internetGatewayRuleId = null, string ipV4Address = null, int? port = null, InternetGatewayType typePropertiesType = default, ResourceIdentifier networkFabricControllerId = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkFabricInternetGatewayData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                internetGatewayRuleId,
                ipV4Address,
                port,
                typePropertiesType,
                networkFabricControllerId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricInternetGatewayRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="ruleProperties"> Rules for the InternetGateways. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="internetGatewayIds"> List of Internet Gateway resource Id. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricInternetGatewayRuleData"/> instance for mocking. </returns>
        public static NetworkFabricInternetGatewayRuleData NetworkFabricInternetGatewayRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, InternetGatewayRules ruleProperties = null, NetworkFabricProvisioningState? provisioningState = null, IEnumerable<ResourceIdentifier> internetGatewayIds = null)
        {
            tags ??= new Dictionary<string, string>();
            internetGatewayIds ??= new List<ResourceIdentifier>();

            return new NetworkFabricInternetGatewayRuleData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                ruleProperties,
                provisioningState,
                internetGatewayIds?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricIPCommunityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="ipCommunityRules"> List of IP Community Rules. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricIPCommunityData"/> instance for mocking. </returns>
        public static NetworkFabricIPCommunityData NetworkFabricIPCommunityData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, IEnumerable<IPCommunityRule> ipCommunityRules = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            ipCommunityRules ??= new List<IPCommunityRule>();

            return new NetworkFabricIPCommunityData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                ipCommunityRules?.ToList(),
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricIPExtendedCommunityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="ipExtendedCommunityRules"> List of IP Extended Community Rules. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricIPExtendedCommunityData"/> instance for mocking. </returns>
        public static NetworkFabricIPExtendedCommunityData NetworkFabricIPExtendedCommunityData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, IEnumerable<IPExtendedCommunityRule> ipExtendedCommunityRules = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            ipExtendedCommunityRules ??= new List<IPExtendedCommunityRule>();

            return new NetworkFabricIPExtendedCommunityData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                ipExtendedCommunityRules?.ToList(),
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricIPPrefixData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="ipPrefixRules"> The list of IP Prefix Rules. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricIPPrefixData"/> instance for mocking. </returns>
        public static NetworkFabricIPPrefixData NetworkFabricIPPrefixData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, IEnumerable<IPPrefixRule> ipPrefixRules = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            ipPrefixRules ??= new List<IPPrefixRule>();

            return new NetworkFabricIPPrefixData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                ipPrefixRules?.ToList(),
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricL2IsolationDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="networkFabricId"> ARM Resource ID of the Network Fabric. </param>
        /// <param name="vlanId"> Vlan Identifier of the Network Fabric. Example: 501. </param>
        /// <param name="mtu"> Maximum transmission unit. Default value is 1500. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricL2IsolationDomainData"/> instance for mocking. </returns>
        public static NetworkFabricL2IsolationDomainData NetworkFabricL2IsolationDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, ResourceIdentifier networkFabricId = null, int vlanId = default, int? mtu = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkFabricL2IsolationDomainData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                networkFabricId,
                vlanId,
                mtu,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DeviceUpdateCommonPostActionResult"/>. </summary>
        /// <param name="error"> The error object. </param>
        /// <param name="configurationState"> Gets the configuration state. </param>
        /// <param name="successfulDevices"> List of ARM Resource IDs for which the given action applied successfully. </param>
        /// <param name="failedDevices"> List of ARM Resource IDs for which the given action failed to apply. </param>
        /// <returns> A new <see cref="Models.DeviceUpdateCommonPostActionResult"/> instance for mocking. </returns>
        public static DeviceUpdateCommonPostActionResult DeviceUpdateCommonPostActionResult(ResponseError error = null, NetworkFabricConfigurationState? configurationState = null, IEnumerable<string> successfulDevices = null, IEnumerable<string> failedDevices = null)
        {
            successfulDevices ??= new List<string>();
            failedDevices ??= new List<string>();

            return new DeviceUpdateCommonPostActionResult(error, serializedAdditionalRawData: null, configurationState, successfulDevices?.ToList(), failedDevices?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricL3IsolationDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="redistributeConnectedSubnets"> Advertise Connected Subnets. Ex: "True" | "False". </param>
        /// <param name="redistributeStaticRoutes"> Advertise Static Routes. Ex: "True" | "False". </param>
        /// <param name="aggregateRouteConfiguration"> Aggregate route configurations. </param>
        /// <param name="connectedSubnetRoutePolicy"> Connected Subnet RoutePolicy. </param>
        /// <param name="networkFabricId"> ARM Resource ID of the Network Fabric. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricL3IsolationDomainData"/> instance for mocking. </returns>
        public static NetworkFabricL3IsolationDomainData NetworkFabricL3IsolationDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, RedistributeConnectedSubnet? redistributeConnectedSubnets = null, RedistributeStaticRoute? redistributeStaticRoutes = null, AggregateRouteConfiguration aggregateRouteConfiguration = null, ConnectedSubnetRoutePolicy connectedSubnetRoutePolicy = null, ResourceIdentifier networkFabricId = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkFabricL3IsolationDomainData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                redistributeConnectedSubnets,
                redistributeStaticRoutes,
                aggregateRouteConfiguration,
                connectedSubnetRoutePolicy,
                networkFabricId,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricInternalNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="mtu"> Maximum transmission unit. Default value is 1500. </param>
        /// <param name="connectedIPv4Subnets"> List of Connected IPv4 Subnets. </param>
        /// <param name="connectedIPv6Subnets"> List of connected IPv6 Subnets. </param>
        /// <param name="importRoutePolicyId"> ARM Resource ID of the RoutePolicy. This is used for the backward compatibility. </param>
        /// <param name="exportRoutePolicyId"> ARM Resource ID of the RoutePolicy. This is used for the backward compatibility. </param>
        /// <param name="importRoutePolicy"> Import Route Policy either IPv4 or IPv6. </param>
        /// <param name="exportRoutePolicy"> Export Route Policy either IPv4 or IPv6. </param>
        /// <param name="ingressAclId"> Ingress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="egressAclId"> Egress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="isMonitoringEnabled"> To check whether monitoring of internal network is enabled or not. </param>
        /// <param name="extension"> Extension. Example: NoExtension | NPB. </param>
        /// <param name="vlanId"> Vlan identifier. Example: 1001. </param>
        /// <param name="bgpConfiguration"> BGP configuration properties. </param>
        /// <param name="staticRouteConfiguration"> Static Route Configuration properties. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricInternalNetworkData"/> instance for mocking. </returns>
        public static NetworkFabricInternalNetworkData NetworkFabricInternalNetworkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string annotation = null, int? mtu = null, IEnumerable<ConnectedSubnet> connectedIPv4Subnets = null, IEnumerable<ConnectedSubnet> connectedIPv6Subnets = null, ResourceIdentifier importRoutePolicyId = null, ResourceIdentifier exportRoutePolicyId = null, ImportRoutePolicy importRoutePolicy = null, ExportRoutePolicy exportRoutePolicy = null, ResourceIdentifier ingressAclId = null, ResourceIdentifier egressAclId = null, IsMonitoringEnabled? isMonitoringEnabled = null, StaticRouteConfigurationExtension? extension = null, int vlanId = default, InternalNetworkBgpConfiguration bgpConfiguration = null, InternalNetworkStaticRouteConfiguration staticRouteConfiguration = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            connectedIPv4Subnets ??= new List<ConnectedSubnet>();
            connectedIPv6Subnets ??= new List<ConnectedSubnet>();

            return new NetworkFabricInternalNetworkData(
                id,
                name,
                resourceType,
                systemData,
                annotation,
                mtu,
                connectedIPv4Subnets?.ToList(),
                connectedIPv6Subnets?.ToList(),
                importRoutePolicyId,
                exportRoutePolicyId,
                importRoutePolicy,
                exportRoutePolicy,
                ingressAclId,
                egressAclId,
                isMonitoringEnabled,
                extension,
                vlanId,
                bgpConfiguration,
                staticRouteConfiguration,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InternalNetworkBgpConfiguration"/>. </summary>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="bfdConfiguration"> BFD configuration properties. </param>
        /// <param name="defaultRouteOriginate"> Originate a defaultRoute. Ex: "True" | "False". </param>
        /// <param name="allowAS"> Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2. </param>
        /// <param name="allowASOverride"> Enable Or Disable state. </param>
        /// <param name="fabricAsn"> ASN of Network Fabric. Example: 65048. </param>
        /// <param name="peerAsn"> Peer ASN. Example: 65047. </param>
        /// <param name="ipv4ListenRangePrefixes"> List of BGP IPv4 Listen Range prefixes. </param>
        /// <param name="ipv6ListenRangePrefixes"> List of BGP IPv6 Listen Ranges prefixes. </param>
        /// <param name="ipv4NeighborAddress"> List with stringified IPv4 Neighbor Addresses. </param>
        /// <param name="ipv6NeighborAddress"> List with stringified IPv6 Neighbor Address. </param>
        /// <returns> A new <see cref="Models.InternalNetworkBgpConfiguration"/> instance for mocking. </returns>
        public static InternalNetworkBgpConfiguration InternalNetworkBgpConfiguration(string annotation = null, BfdConfiguration bfdConfiguration = null, NetworkFabricBooleanValue? defaultRouteOriginate = null, int? allowAS = null, AllowASOverride? allowASOverride = null, long? fabricAsn = null, long? peerAsn = null, IEnumerable<string> ipv4ListenRangePrefixes = null, IEnumerable<string> ipv6ListenRangePrefixes = null, IEnumerable<NeighborAddress> ipv4NeighborAddress = null, IEnumerable<NeighborAddress> ipv6NeighborAddress = null)
        {
            ipv4ListenRangePrefixes ??= new List<string>();
            ipv6ListenRangePrefixes ??= new List<string>();
            ipv4NeighborAddress ??= new List<NeighborAddress>();
            ipv6NeighborAddress ??= new List<NeighborAddress>();

            return new InternalNetworkBgpConfiguration(
                annotation,
                serializedAdditionalRawData: null,
                bfdConfiguration,
                defaultRouteOriginate,
                allowAS,
                allowASOverride,
                fabricAsn,
                peerAsn,
                ipv4ListenRangePrefixes?.ToList(),
                ipv6ListenRangePrefixes?.ToList(),
                ipv4NeighborAddress?.ToList(),
                ipv6NeighborAddress?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.BgpConfiguration"/>. </summary>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="bfdConfiguration"> BFD configuration properties. </param>
        /// <param name="defaultRouteOriginate"> Originate a defaultRoute. Ex: "True" | "False". </param>
        /// <param name="allowAS"> Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2. </param>
        /// <param name="allowASOverride"> Enable Or Disable state. </param>
        /// <param name="fabricAsn"> ASN of Network Fabric. Example: 65048. </param>
        /// <param name="peerAsn"> Peer ASN. Example: 65047. </param>
        /// <param name="ipv4ListenRangePrefixes"> List of BGP IPv4 Listen Range prefixes. </param>
        /// <param name="ipv6ListenRangePrefixes"> List of BGP IPv6 Listen Ranges prefixes. </param>
        /// <param name="ipv4NeighborAddress"> List with stringified IPv4 Neighbor Addresses. </param>
        /// <param name="ipv6NeighborAddress"> List with stringified IPv6 Neighbor Address. </param>
        /// <returns> A new <see cref="Models.BgpConfiguration"/> instance for mocking. </returns>
        public static BgpConfiguration BgpConfiguration(string annotation = null, BfdConfiguration bfdConfiguration = null, NetworkFabricBooleanValue? defaultRouteOriginate = null, int? allowAS = null, AllowASOverride? allowASOverride = null, long? fabricAsn = null, long? peerAsn = null, IEnumerable<string> ipv4ListenRangePrefixes = null, IEnumerable<string> ipv6ListenRangePrefixes = null, IEnumerable<NeighborAddress> ipv4NeighborAddress = null, IEnumerable<NeighborAddress> ipv6NeighborAddress = null)
        {
            ipv4ListenRangePrefixes ??= new List<string>();
            ipv6ListenRangePrefixes ??= new List<string>();
            ipv4NeighborAddress ??= new List<NeighborAddress>();
            ipv6NeighborAddress ??= new List<NeighborAddress>();

            return new BgpConfiguration(
                annotation,
                serializedAdditionalRawData: null,
                bfdConfiguration,
                defaultRouteOriginate,
                allowAS,
                allowASOverride,
                fabricAsn,
                peerAsn,
                ipv4ListenRangePrefixes?.ToList(),
                ipv6ListenRangePrefixes?.ToList(),
                ipv4NeighborAddress?.ToList(),
                ipv6NeighborAddress?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.BfdConfiguration"/>. </summary>
        /// <param name="administrativeState"> Administrative state of the BfdConfiguration. Example: Enabled | Disabled. </param>
        /// <param name="intervalInMilliSeconds"> Interval in milliseconds. Example: 300. </param>
        /// <param name="multiplier"> Multiplier for the Bfd Configuration. Example: 5. </param>
        /// <returns> A new <see cref="Models.BfdConfiguration"/> instance for mocking. </returns>
        public static BfdConfiguration BfdConfiguration(BfdAdministrativeState? administrativeState = null, int? intervalInMilliSeconds = null, int? multiplier = null)
        {
            return new BfdConfiguration(administrativeState, intervalInMilliSeconds, multiplier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NeighborAddress"/>. </summary>
        /// <param name="address"> IP Address. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <returns> A new <see cref="Models.NeighborAddress"/> instance for mocking. </returns>
        public static NeighborAddress NeighborAddress(string address = null, NetworkFabricConfigurationState? configurationState = null)
        {
            return new NeighborAddress(address, configurationState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricExternalNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="importRoutePolicyId"> ARM Resource ID of the RoutePolicy. This is used for the backward compatibility. </param>
        /// <param name="exportRoutePolicyId"> ARM Resource ID of the RoutePolicy. This is used for the backward compatibility. </param>
        /// <param name="importRoutePolicy"> Import Route Policy either IPv4 or IPv6. </param>
        /// <param name="exportRoutePolicy"> Export Route Policy either IPv4 or IPv6. </param>
        /// <param name="networkToNetworkInterconnectId"> Gets the networkToNetworkInterconnectId of the resource. </param>
        /// <param name="peeringOption"> Peering option list. </param>
        /// <param name="optionBProperties"> option B properties object. </param>
        /// <param name="optionAProperties"> option A properties object. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricExternalNetworkData"/> instance for mocking. </returns>
        public static NetworkFabricExternalNetworkData NetworkFabricExternalNetworkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string annotation = null, ResourceIdentifier importRoutePolicyId = null, ResourceIdentifier exportRoutePolicyId = null, ImportRoutePolicy importRoutePolicy = null, ExportRoutePolicy exportRoutePolicy = null, ResourceIdentifier networkToNetworkInterconnectId = null, PeeringOption peeringOption = default, L3OptionBProperties optionBProperties = null, ExternalNetworkOptionAProperties optionAProperties = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            return new NetworkFabricExternalNetworkData(
                id,
                name,
                resourceType,
                systemData,
                annotation,
                importRoutePolicyId,
                exportRoutePolicyId,
                importRoutePolicy,
                exportRoutePolicy,
                networkToNetworkInterconnectId,
                peeringOption,
                optionBProperties,
                optionAProperties,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExternalNetworkOptionAProperties"/>. </summary>
        /// <param name="primaryIPv4Prefix"> IPv4 Address Prefix. </param>
        /// <param name="primaryIPv6Prefix"> IPv6 Address Prefix. </param>
        /// <param name="secondaryIPv4Prefix"> Secondary IPv4 Address Prefix. </param>
        /// <param name="secondaryIPv6Prefix"> Secondary IPv6 Address Prefix. </param>
        /// <param name="mtu"> MTU to use for option A peering. </param>
        /// <param name="vlanId"> Vlan identifier. Example : 501. </param>
        /// <param name="fabricAsn"> Fabric ASN number. Example 65001. </param>
        /// <param name="peerAsn"> Peer ASN number.Example : 28. </param>
        /// <param name="bfdConfiguration"> BFD configuration properties. </param>
        /// <param name="ingressAclId"> Ingress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="egressAclId"> Egress Acl. ARM resource ID of Access Control Lists. </param>
        /// <returns> A new <see cref="Models.ExternalNetworkOptionAProperties"/> instance for mocking. </returns>
        public static ExternalNetworkOptionAProperties ExternalNetworkOptionAProperties(string primaryIPv4Prefix = null, string primaryIPv6Prefix = null, string secondaryIPv4Prefix = null, string secondaryIPv6Prefix = null, int? mtu = null, int? vlanId = null, long? fabricAsn = null, long? peerAsn = null, BfdConfiguration bfdConfiguration = null, ResourceIdentifier ingressAclId = null, ResourceIdentifier egressAclId = null)
        {
            return new ExternalNetworkOptionAProperties(
                primaryIPv4Prefix,
                primaryIPv6Prefix,
                secondaryIPv4Prefix,
                secondaryIPv6Prefix,
                serializedAdditionalRawData: null,
                mtu,
                vlanId,
                fabricAsn,
                peerAsn,
                bfdConfiguration,
                ingressAclId,
                egressAclId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExternalNetworkPatchOptionAProperties"/>. </summary>
        /// <param name="primaryIPv4Prefix"> IPv4 Address Prefix. </param>
        /// <param name="primaryIPv6Prefix"> IPv6 Address Prefix. </param>
        /// <param name="secondaryIPv4Prefix"> Secondary IPv4 Address Prefix. </param>
        /// <param name="secondaryIPv6Prefix"> Secondary IPv6 Address Prefix. </param>
        /// <param name="mtu"> MTU to use for option A peering. </param>
        /// <param name="vlanId"> Vlan identifier. Example : 501. </param>
        /// <param name="fabricAsn"> Fabric ASN number. Example 65001. </param>
        /// <param name="peerAsn"> Peer ASN number.Example : 28. </param>
        /// <param name="bfdConfiguration"> BFD configuration properties. </param>
        /// <param name="ingressAclId"> Ingress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="egressAclId"> Egress Acl. ARM resource ID of Access Control Lists. </param>
        /// <returns> A new <see cref="Models.ExternalNetworkPatchOptionAProperties"/> instance for mocking. </returns>
        public static ExternalNetworkPatchOptionAProperties ExternalNetworkPatchOptionAProperties(string primaryIPv4Prefix = null, string primaryIPv6Prefix = null, string secondaryIPv4Prefix = null, string secondaryIPv6Prefix = null, int? mtu = null, int? vlanId = null, long? fabricAsn = null, long? peerAsn = null, BfdConfiguration bfdConfiguration = null, ResourceIdentifier ingressAclId = null, ResourceIdentifier egressAclId = null)
        {
            return new ExternalNetworkPatchOptionAProperties(
                primaryIPv4Prefix,
                primaryIPv6Prefix,
                secondaryIPv4Prefix,
                secondaryIPv6Prefix,
                serializedAdditionalRawData: null,
                mtu,
                vlanId,
                fabricAsn,
                peerAsn,
                bfdConfiguration,
                ingressAclId,
                egressAclId);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricNeighborGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="destination"> An array of destination IPv4 Addresses or IPv6 Addresses. </param>
        /// <param name="networkTapIds"> List of NetworkTap IDs where neighbor group is associated. </param>
        /// <param name="networkTapRuleIds"> List of Network Tap Rule IDs where neighbor group is associated. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricNeighborGroupData"/> instance for mocking. </returns>
        public static NetworkFabricNeighborGroupData NetworkFabricNeighborGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, NeighborGroupDestination destination = null, IEnumerable<ResourceIdentifier> networkTapIds = null, IEnumerable<ResourceIdentifier> networkTapRuleIds = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            networkTapIds ??= new List<ResourceIdentifier>();
            networkTapRuleIds ??= new List<ResourceIdentifier>();

            return new NetworkFabricNeighborGroupData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                destination,
                networkTapIds?.ToList(),
                networkTapRuleIds?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkDeviceSkuData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="model"> Model of the network device. </param>
        /// <param name="manufacturer"> Manufacturer of the network device. </param>
        /// <param name="supportedVersions"> List of supported version details of network device. </param>
        /// <param name="supportedRoleTypes"> Available roles for the network device. </param>
        /// <param name="interfaces"> List of network device interfaces. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkDeviceSkuData"/> instance for mocking. </returns>
        public static NetworkDeviceSkuData NetworkDeviceSkuData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string model = null, string manufacturer = null, IEnumerable<SupportedVersionProperties> supportedVersions = null, IEnumerable<NetworkDeviceRoleName> supportedRoleTypes = null, IEnumerable<NetworkDeviceInterfaceProperties> interfaces = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            supportedVersions ??= new List<SupportedVersionProperties>();
            supportedRoleTypes ??= new List<NetworkDeviceRoleName>();
            interfaces ??= new List<NetworkDeviceInterfaceProperties>();

            return new NetworkDeviceSkuData(
                id,
                name,
                resourceType,
                systemData,
                model,
                manufacturer,
                supportedVersions?.ToList(),
                supportedRoleTypes?.ToList(),
                interfaces?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkDeviceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="hostName"> The host name of the device. </param>
        /// <param name="serialNumber"> Serial number of the device. Format of serial Number - Make;Model;HardwareRevisionId;SerialNumber. </param>
        /// <param name="version"> Current version of the device as defined in SKU. </param>
        /// <param name="networkDeviceSku"> Network Device SKU name. </param>
        /// <param name="networkDeviceRole"> NetworkDeviceRole is the device role: Example: CE | ToR. </param>
        /// <param name="networkRackId"> Reference to network rack resource id. </param>
        /// <param name="managementIPv4Address"> Management IPv4 Address. </param>
        /// <param name="managementIPv6Address"> Management IPv6 Address. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkDeviceData"/> instance for mocking. </returns>
        public static NetworkDeviceData NetworkDeviceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, string hostName = null, string serialNumber = null, string version = null, string networkDeviceSku = null, NetworkDeviceRole? networkDeviceRole = null, ResourceIdentifier networkRackId = null, IPAddress managementIPv4Address = null, string managementIPv6Address = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkDeviceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                hostName,
                serialNumber,
                version,
                networkDeviceSku,
                networkDeviceRole,
                networkRackId,
                managementIPv4Address,
                managementIPv6Address,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkDeviceInterfaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="physicalIdentifier"> Physical Identifier of the network interface. </param>
        /// <param name="connectedTo"> The ARM resource id of the interface or compute server its connected to. </param>
        /// <param name="interfaceType"> The Interface Type. Example: Management/Data. </param>
        /// <param name="ipv4Address"> IPv4Address of the interface. </param>
        /// <param name="ipv6Address"> IPv6Address of the interface. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkDeviceInterfaceData"/> instance for mocking. </returns>
        public static NetworkDeviceInterfaceData NetworkDeviceInterfaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string annotation = null, string physicalIdentifier = null, string connectedTo = null, NetworkDeviceInterfaceType? interfaceType = null, IPAddress ipv4Address = null, string ipv6Address = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            return new NetworkDeviceInterfaceData(
                id,
                name,
                resourceType,
                systemData,
                annotation,
                physicalIdentifier,
                connectedTo,
                interfaceType,
                ipv4Address,
                ipv6Address,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricControllerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="infrastructureExpressRouteConnections"> As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute). </param>
        /// <param name="workloadExpressRouteConnections"> As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute). </param>
        /// <param name="infrastructureServices"> InfrastructureServices IP ranges. </param>
        /// <param name="workloadServices"> WorkloadServices IP ranges. </param>
        /// <param name="managedResourceGroupConfiguration"> Managed Resource Group configuration properties. </param>
        /// <param name="networkFabricIds"> The NF-ID will be an input parameter used by the NF to link and get associated with the parent NFC Service. </param>
        /// <param name="isWorkloadManagementNetwork"> A workload management network is required for all the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to access internet or any other MSFT/Public endpoints. This is used for the backward compatibility. </param>
        /// <param name="isWorkloadManagementNetworkEnabled"> A workload management network is required for all the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to access internet or any other MSFT/Public endpoints. </param>
        /// <param name="tenantInternetGatewayIds"> List of tenant InternetGateway resource IDs. </param>
        /// <param name="ipv4AddressSpace"> IPv4 Network Fabric Controller Address Space. </param>
        /// <param name="ipv6AddressSpace"> IPv6 Network Fabric Controller Address Space. </param>
        /// <param name="nfcSku"> Network Fabric Controller SKU. </param>
        /// <param name="provisioningState"> Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of NFC provisioning. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricControllerData"/> instance for mocking. </returns>
        public static NetworkFabricControllerData NetworkFabricControllerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, IEnumerable<ExpressRouteConnectionInformation> infrastructureExpressRouteConnections = null, IEnumerable<ExpressRouteConnectionInformation> workloadExpressRouteConnections = null, NetworkFabricControllerServices infrastructureServices = null, NetworkFabricControllerServices workloadServices = null, ManagedResourceGroupConfiguration managedResourceGroupConfiguration = null, IEnumerable<ResourceIdentifier> networkFabricIds = null, bool? isWorkloadManagementNetwork = null, IsWorkloadManagementNetworkEnabled? isWorkloadManagementNetworkEnabled = null, IEnumerable<ResourceIdentifier> tenantInternetGatewayIds = null, string ipv4AddressSpace = null, string ipv6AddressSpace = null, NetworkFabricControllerSKU? nfcSku = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            infrastructureExpressRouteConnections ??= new List<ExpressRouteConnectionInformation>();
            workloadExpressRouteConnections ??= new List<ExpressRouteConnectionInformation>();
            networkFabricIds ??= new List<ResourceIdentifier>();
            tenantInternetGatewayIds ??= new List<ResourceIdentifier>();

            return new NetworkFabricControllerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                infrastructureExpressRouteConnections?.ToList(),
                workloadExpressRouteConnections?.ToList(),
                infrastructureServices,
                workloadServices,
                managedResourceGroupConfiguration,
                networkFabricIds?.ToList(),
                isWorkloadManagementNetwork,
                isWorkloadManagementNetworkEnabled,
                tenantInternetGatewayIds?.ToList(),
                ipv4AddressSpace,
                ipv6AddressSpace,
                nfcSku,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkFabricControllerServices"/>. </summary>
        /// <param name="ipv4AddressSpaces"> The IPv4 Address space is optional, if the value is not defined at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet is an optional attribute. </param>
        /// <param name="ipv6AddressSpaces"> The IPv6 is not supported right now. </param>
        /// <returns> A new <see cref="Models.NetworkFabricControllerServices"/> instance for mocking. </returns>
        public static NetworkFabricControllerServices NetworkFabricControllerServices(IEnumerable<string> ipv4AddressSpaces = null, IEnumerable<string> ipv6AddressSpaces = null)
        {
            ipv4AddressSpaces ??= new List<string>();
            ipv6AddressSpaces ??= new List<string>();

            return new NetworkFabricControllerServices(ipv4AddressSpaces?.ToList(), ipv6AddressSpaces?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricSkuData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="typePropertiesType"> Type of Network Fabric SKU. </param>
        /// <param name="maxComputeRacks"> Maximum number of compute racks available for this Network Fabric SKU. The value of max count racks is 4 for 4 rack SKU and 8 for 8 rack SKU. </param>
        /// <param name="maximumServerCount"> Maximum number of servers available for this Network Fabric SKU. </param>
        /// <param name="supportedVersions"> List of supported Network Fabric SKU versions. </param>
        /// <param name="details"> URL providing detailed configuration of the fabric SKU. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricSkuData"/> instance for mocking. </returns>
        public static NetworkFabricSkuData NetworkFabricSkuData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NetworkFabricSkuType? typePropertiesType = null, int? maxComputeRacks = null, int? maximumServerCount = null, IEnumerable<string> supportedVersions = null, string details = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            supportedVersions ??= new List<string>();

            return new NetworkFabricSkuData(
                id,
                name,
                resourceType,
                systemData,
                typePropertiesType,
                maxComputeRacks,
                maximumServerCount,
                supportedVersions?.ToList(),
                details,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="networkFabricSku"> Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The SKU determines whether it is a single / multi rack Network Fabric. </param>
        /// <param name="fabricVersion"> The version of Network Fabric. </param>
        /// <param name="routerIds"> Array of router IDs. </param>
        /// <param name="networkFabricControllerId"> Azure resource ID for the NetworkFabricController the NetworkFabric belongs. </param>
        /// <param name="rackCount"> Number of compute racks associated to Network Fabric. </param>
        /// <param name="serverCountPerRack"> Number of servers.Possible values are from 1-16. </param>
        /// <param name="ipv4Prefix"> IPv4Prefix for Management Network. Example: 10.1.0.0/19. </param>
        /// <param name="ipv6Prefix"> IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59. </param>
        /// <param name="fabricAsn"> ASN of CE devices for CE/PE connectivity. </param>
        /// <param name="terminalServerConfiguration"> Network and credentials configuration currently applied to terminal server. </param>
        /// <param name="managementNetworkConfiguration"> Configuration to be used to setup the management network. </param>
        /// <param name="racks"> List of NetworkRack resource IDs under the Network Fabric. The number of racks allowed depends on the Network Fabric SKU. </param>
        /// <param name="l2IsolationDomains"> List of L2 Isolation Domain resource IDs under the Network Fabric. </param>
        /// <param name="l3IsolationDomains"> List of L3 Isolation Domain resource IDs under the Network Fabric. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of NFC provisioning. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricData"/> instance for mocking. </returns>
        public static NetworkFabricData NetworkFabricData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, string networkFabricSku = null, string fabricVersion = null, IEnumerable<string> routerIds = null, ResourceIdentifier networkFabricControllerId = null, int? rackCount = null, int serverCountPerRack = default, string ipv4Prefix = null, string ipv6Prefix = null, long fabricAsn = default, TerminalServerConfiguration terminalServerConfiguration = null, ManagementNetworkConfigurationProperties managementNetworkConfiguration = null, IEnumerable<string> racks = null, IEnumerable<string> l2IsolationDomains = null, IEnumerable<string> l3IsolationDomains = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            routerIds ??= new List<string>();
            racks ??= new List<string>();
            l2IsolationDomains ??= new List<string>();
            l3IsolationDomains ??= new List<string>();

            return new NetworkFabricData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                networkFabricSku,
                fabricVersion,
                routerIds?.ToList(),
                networkFabricControllerId,
                rackCount,
                serverCountPerRack,
                ipv4Prefix,
                ipv6Prefix,
                fabricAsn,
                terminalServerConfiguration,
                managementNetworkConfiguration,
                racks?.ToList(),
                l2IsolationDomains?.ToList(),
                l3IsolationDomains?.ToList(),
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TerminalServerConfiguration"/>. </summary>
        /// <param name="username"> Username for the terminal server connection. </param>
        /// <param name="password"> Password for the terminal server connection. </param>
        /// <param name="serialNumber"> Serial Number of Terminal server. </param>
        /// <param name="networkDeviceId"> ARM Resource ID used for the NetworkDevice. </param>
        /// <param name="primaryIPv4Prefix"> IPv4 Address Prefix. </param>
        /// <param name="primaryIPv6Prefix"> IPv6 Address Prefix. </param>
        /// <param name="secondaryIPv4Prefix"> Secondary IPv4 Address Prefix. </param>
        /// <param name="secondaryIPv6Prefix"> Secondary IPv6 Address Prefix. </param>
        /// <returns> A new <see cref="Models.TerminalServerConfiguration"/> instance for mocking. </returns>
        public static TerminalServerConfiguration TerminalServerConfiguration(string username = null, string password = null, string serialNumber = null, ResourceIdentifier networkDeviceId = null, string primaryIPv4Prefix = null, string primaryIPv6Prefix = null, string secondaryIPv4Prefix = null, string secondaryIPv6Prefix = null)
        {
            return new TerminalServerConfiguration(
                username,
                password,
                serialNumber,
                serializedAdditionalRawData: null,
                networkDeviceId,
                primaryIPv4Prefix,
                primaryIPv6Prefix,
                secondaryIPv4Prefix,
                secondaryIPv6Prefix);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnConfigurationProperties"/>. </summary>
        /// <param name="networkToNetworkInterconnectId"> ARM Resource ID of the Network To Network Interconnect. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <param name="peeringOption"> Peering option list. </param>
        /// <param name="optionBProperties"> option B properties. </param>
        /// <param name="optionAProperties"> option A properties. </param>
        /// <returns> A new <see cref="Models.VpnConfigurationProperties"/> instance for mocking. </returns>
        public static VpnConfigurationProperties VpnConfigurationProperties(ResourceIdentifier networkToNetworkInterconnectId = null, NetworkFabricAdministrativeState? administrativeState = null, PeeringOption peeringOption = default, OptionBProperties optionBProperties = null, VpnConfigurationOptionAProperties optionAProperties = null)
        {
            return new VpnConfigurationProperties(
                networkToNetworkInterconnectId,
                administrativeState,
                peeringOption,
                optionBProperties,
                optionAProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkToNetworkInterconnectData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="nniType"> Type of NNI used. Example: CE | NPB. </param>
        /// <param name="isManagementType"> Configuration to use NNI for Infrastructure Management. Example: True/False. </param>
        /// <param name="useOptionB"> Based on this option layer3 parameters are mandatory. Example: True/False. </param>
        /// <param name="layer2Configuration"> Common properties for Layer2 Configuration. </param>
        /// <param name="optionBLayer3Configuration"> Common properties for Layer3Configuration. </param>
        /// <param name="npbStaticRouteConfiguration"> NPB Static Route Configuration properties. </param>
        /// <param name="importRoutePolicy"> Import Route Policy configuration. </param>
        /// <param name="exportRoutePolicy"> Export Route Policy configuration. </param>
        /// <param name="egressAclId"> Egress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="ingressAclId"> Ingress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkToNetworkInterconnectData"/> instance for mocking. </returns>
        public static NetworkToNetworkInterconnectData NetworkToNetworkInterconnectData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NniType? nniType = null, IsManagementType? isManagementType = null, NetworkFabricBooleanValue useOptionB = default, Layer2Configuration layer2Configuration = null, NetworkToNetworkInterconnectOptionBLayer3Configuration optionBLayer3Configuration = null, NpbStaticRouteConfiguration npbStaticRouteConfiguration = null, ImportRoutePolicyInformation importRoutePolicy = null, ExportRoutePolicyInformation exportRoutePolicy = null, ResourceIdentifier egressAclId = null, ResourceIdentifier ingressAclId = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            return new NetworkToNetworkInterconnectData(
                id,
                name,
                resourceType,
                systemData,
                nniType,
                isManagementType,
                useOptionB,
                layer2Configuration,
                optionBLayer3Configuration,
                npbStaticRouteConfiguration,
                importRoutePolicy,
                exportRoutePolicy,
                egressAclId,
                ingressAclId,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkToNetworkInterconnectOptionBLayer3Configuration"/>. </summary>
        /// <param name="primaryIPv4Prefix"> IPv4 Address Prefix. </param>
        /// <param name="primaryIPv6Prefix"> IPv6 Address Prefix. </param>
        /// <param name="secondaryIPv4Prefix"> Secondary IPv4 Address Prefix. </param>
        /// <param name="secondaryIPv6Prefix"> Secondary IPv6 Address Prefix. </param>
        /// <param name="peerAsn"> ASN of PE devices for CE/PE connectivity.Example : 28. </param>
        /// <param name="vlanId"> VLAN for CE/PE Layer 3 connectivity.Example : 501. </param>
        /// <param name="fabricAsn"> ASN of CE devices for CE/PE connectivity. </param>
        /// <returns> A new <see cref="Models.NetworkToNetworkInterconnectOptionBLayer3Configuration"/> instance for mocking. </returns>
        public static NetworkToNetworkInterconnectOptionBLayer3Configuration NetworkToNetworkInterconnectOptionBLayer3Configuration(string primaryIPv4Prefix = null, string primaryIPv6Prefix = null, string secondaryIPv4Prefix = null, string secondaryIPv6Prefix = null, long? peerAsn = null, int? vlanId = null, long? fabricAsn = null)
        {
            return new NetworkToNetworkInterconnectOptionBLayer3Configuration(
                primaryIPv4Prefix,
                primaryIPv6Prefix,
                secondaryIPv4Prefix,
                secondaryIPv6Prefix,
                serializedAdditionalRawData: null,
                peerAsn,
                vlanId,
                fabricAsn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OptionBLayer3Configuration"/>. </summary>
        /// <param name="primaryIPv4Prefix"> IPv4 Address Prefix. </param>
        /// <param name="primaryIPv6Prefix"> IPv6 Address Prefix. </param>
        /// <param name="secondaryIPv4Prefix"> Secondary IPv4 Address Prefix. </param>
        /// <param name="secondaryIPv6Prefix"> Secondary IPv6 Address Prefix. </param>
        /// <param name="peerAsn"> ASN of PE devices for CE/PE connectivity.Example : 28. </param>
        /// <param name="vlanId"> VLAN for CE/PE Layer 3 connectivity.Example : 501. </param>
        /// <param name="fabricAsn"> ASN of CE devices for CE/PE connectivity. </param>
        /// <returns> A new <see cref="Models.OptionBLayer3Configuration"/> instance for mocking. </returns>
        public static OptionBLayer3Configuration OptionBLayer3Configuration(string primaryIPv4Prefix = null, string primaryIPv6Prefix = null, string secondaryIPv4Prefix = null, string secondaryIPv6Prefix = null, long? peerAsn = null, int? vlanId = null, long? fabricAsn = null)
        {
            return new OptionBLayer3Configuration(
                primaryIPv4Prefix,
                primaryIPv6Prefix,
                secondaryIPv4Prefix,
                secondaryIPv6Prefix,
                serializedAdditionalRawData: null,
                peerAsn,
                vlanId,
                fabricAsn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkToNetworkInterconnectPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="layer2Configuration"> Common properties for Layer2Configuration. </param>
        /// <param name="optionBLayer3Configuration"> Common properties for Layer3Configuration. </param>
        /// <param name="npbStaticRouteConfiguration"> NPB Static Route Configuration properties. </param>
        /// <param name="importRoutePolicy"> Import Route Policy information. </param>
        /// <param name="exportRoutePolicy"> Export Route Policy information. </param>
        /// <param name="egressAclId"> Egress Acl. ARM resource ID of Access Control Lists. </param>
        /// <param name="ingressAclId"> Ingress Acl. ARM resource ID of Access Control Lists. </param>
        /// <returns> A new <see cref="Models.NetworkToNetworkInterconnectPatch"/> instance for mocking. </returns>
        public static NetworkToNetworkInterconnectPatch NetworkToNetworkInterconnectPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Layer2Configuration layer2Configuration = null, OptionBLayer3Configuration optionBLayer3Configuration = null, NpbStaticRouteConfiguration npbStaticRouteConfiguration = null, ImportRoutePolicyInformation importRoutePolicy = null, ExportRoutePolicyInformation exportRoutePolicy = null, ResourceIdentifier egressAclId = null, ResourceIdentifier ingressAclId = null)
        {
            return new NetworkToNetworkInterconnectPatch(
                id,
                name,
                resourceType,
                systemData,
                layer2Configuration,
                optionBLayer3Configuration,
                npbStaticRouteConfiguration,
                importRoutePolicy,
                exportRoutePolicy,
                egressAclId,
                ingressAclId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkPacketBrokerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="networkFabricId"> ARM resource ID of the Network Fabric. </param>
        /// <param name="networkDeviceIds"> List of ARM resource IDs of Network Devices [NPB]. </param>
        /// <param name="sourceInterfaceIds"> List of network interfaces across NPB devices that are used to mirror source traffic. </param>
        /// <param name="networkTapIds"> List of network Tap IDs configured on NPB. </param>
        /// <param name="neighborGroupIds"> List of neighbor group IDs configured on NPB. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkPacketBrokerData"/> instance for mocking. </returns>
        public static NetworkPacketBrokerData NetworkPacketBrokerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ResourceIdentifier networkFabricId = null, IEnumerable<ResourceIdentifier> networkDeviceIds = null, IEnumerable<ResourceIdentifier> sourceInterfaceIds = null, IEnumerable<ResourceIdentifier> networkTapIds = null, IEnumerable<ResourceIdentifier> neighborGroupIds = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            networkDeviceIds ??= new List<ResourceIdentifier>();
            sourceInterfaceIds ??= new List<ResourceIdentifier>();
            networkTapIds ??= new List<ResourceIdentifier>();
            neighborGroupIds ??= new List<ResourceIdentifier>();

            return new NetworkPacketBrokerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                networkFabricId,
                networkDeviceIds?.ToList(),
                sourceInterfaceIds?.ToList(),
                networkTapIds?.ToList(),
                neighborGroupIds?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkRackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="networkRackType"> Network Rack SKU name. </param>
        /// <param name="networkFabricId"> ARM resource ID of the Network Fabric. </param>
        /// <param name="networkDevices"> List of network device ARM resource IDs. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkRackData"/> instance for mocking. </returns>
        public static NetworkRackData NetworkRackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, NetworkRackType? networkRackType = null, ResourceIdentifier networkFabricId = null, IEnumerable<ResourceIdentifier> networkDevices = null, NetworkFabricProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            networkDevices ??= new List<ResourceIdentifier>();

            return new NetworkRackData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                networkRackType,
                networkFabricId,
                networkDevices?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkTapRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="configurationType"> Input method to configure Network Tap Rule. </param>
        /// <param name="tapRulesUri"> Network Tap Rules file URL. </param>
        /// <param name="matchConfigurations"> List of match configurations. </param>
        /// <param name="dynamicMatchConfigurations"> List of dynamic match configurations. </param>
        /// <param name="networkTapId"> The ARM resource Id of the NetworkTap. </param>
        /// <param name="pollingIntervalInSeconds"> Polling interval in seconds. </param>
        /// <param name="lastSyncedOn"> The last sync timestamp. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkTapRuleData"/> instance for mocking. </returns>
        public static NetworkTapRuleData NetworkTapRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, NetworkFabricConfigurationType? configurationType = null, Uri tapRulesUri = null, IEnumerable<NetworkTapRuleMatchConfiguration> matchConfigurations = null, IEnumerable<CommonDynamicMatchConfiguration> dynamicMatchConfigurations = null, ResourceIdentifier networkTapId = null, PollingIntervalInSecond? pollingIntervalInSeconds = null, DateTimeOffset? lastSyncedOn = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            matchConfigurations ??= new List<NetworkTapRuleMatchConfiguration>();
            dynamicMatchConfigurations ??= new List<CommonDynamicMatchConfiguration>();

            return new NetworkTapRuleData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                configurationType,
                tapRulesUri,
                matchConfigurations?.ToList(),
                dynamicMatchConfigurations?.ToList(),
                networkTapId,
                pollingIntervalInSeconds,
                lastSyncedOn,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkTapData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="networkPacketBrokerId"> ARM resource ID of the Network Packet Broker. </param>
        /// <param name="sourceTapRuleId"> Source Tap Rule Id. ARM Resource ID of the Network Tap Rule. </param>
        /// <param name="destinations"> List of destinations to send the filter traffic. </param>
        /// <param name="pollingType"> Polling type. </param>
        /// <param name="configurationState"> Gets the configurations state of the resource. </param>
        /// <param name="provisioningState"> Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of Network Tap provisioning. </param>
        /// <param name="administrativeState"> Administrative state of the resource. Example -Enabled/Disabled. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkTapData"/> instance for mocking. </returns>
        public static NetworkTapData NetworkTapData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, ResourceIdentifier networkPacketBrokerId = null, ResourceIdentifier sourceTapRuleId = null, IEnumerable<NetworkTapPropertiesDestinationsItem> destinations = null, NetworkTapPollingType? pollingType = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            destinations ??= new List<NetworkTapPropertiesDestinationsItem>();

            return new NetworkTapData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                networkPacketBrokerId,
                sourceTapRuleId,
                destinations?.ToList(),
                pollingType,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkFabric.NetworkFabricRoutePolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="annotation"> Switch configuration description. </param>
        /// <param name="defaultAction"> Default action that needs to be applied when no condition is matched. Example: Permit | Deny. </param>
        /// <param name="statements"> Route Policy statements. </param>
        /// <param name="networkFabricId"> Arm Resource ID of Network Fabric. </param>
        /// <param name="addressFamilyType"> AddressFamilyType. This parameter decides whether the given ipv4 or ipv6 route policy. </param>
        /// <param name="configurationState"> Configuration state of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="administrativeState"> Administrative state of the resource. </param>
        /// <returns> A new <see cref="ManagedNetworkFabric.NetworkFabricRoutePolicyData"/> instance for mocking. </returns>
        public static NetworkFabricRoutePolicyData NetworkFabricRoutePolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string annotation = null, CommunityActionType? defaultAction = null, IEnumerable<RoutePolicyStatementProperties> statements = null, ResourceIdentifier networkFabricId = null, AddressFamilyType? addressFamilyType = null, NetworkFabricConfigurationState? configurationState = null, NetworkFabricProvisioningState? provisioningState = null, NetworkFabricAdministrativeState? administrativeState = null)
        {
            tags ??= new Dictionary<string, string>();
            statements ??= new List<RoutePolicyStatementProperties>();

            return new NetworkFabricRoutePolicyData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                annotation,
                defaultAction,
                statements?.ToList(),
                networkFabricId,
                addressFamilyType,
                configurationState,
                provisioningState,
                administrativeState,
                serializedAdditionalRawData: null);
        }
    }
}
