// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ManagedNetworkFabric.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ManagedNetworkFabric.Samples
{
    public partial class Sample_NetworkPacketBrokerResource
    {
        // NetworkPacketBrokers_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_NetworkPacketBrokersGetMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/NetworkPacketBrokers_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "NetworkPacketBrokers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkPacketBrokerResource created on azure
            // for more information of creating NetworkPacketBrokerResource, please refer to the document of NetworkPacketBrokerResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string resourceGroupName = "example-rg";
            string networkPacketBrokerName = "example-networkPacketBroker";
            ResourceIdentifier networkPacketBrokerResourceId = NetworkPacketBrokerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkPacketBrokerName);
            NetworkPacketBrokerResource networkPacketBroker = client.GetNetworkPacketBrokerResource(networkPacketBrokerResourceId);

            // invoke the operation
            NetworkPacketBrokerResource result = await networkPacketBroker.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkPacketBrokerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // NetworkPacketBrokers_Update_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_NetworkPacketBrokersUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/NetworkPacketBrokers_Update_MaximumSet_Gen.json
            // this example is just showing the usage of "NetworkPacketBrokers_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkPacketBrokerResource created on azure
            // for more information of creating NetworkPacketBrokerResource, please refer to the document of NetworkPacketBrokerResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string resourceGroupName = "example-rg";
            string networkPacketBrokerName = "example-networkPacketBroker";
            ResourceIdentifier networkPacketBrokerResourceId = NetworkPacketBrokerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkPacketBrokerName);
            NetworkPacketBrokerResource networkPacketBroker = client.GetNetworkPacketBrokerResource(networkPacketBrokerResourceId);

            // invoke the operation
            NetworkPacketBrokerPatch patch = new NetworkPacketBrokerPatch()
            {
                Tags =
{
["key8772"] = "1234",
},
            };
            ArmOperation<NetworkPacketBrokerResource> lro = await networkPacketBroker.UpdateAsync(WaitUntil.Completed, patch);
            NetworkPacketBrokerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkPacketBrokerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // NetworkPacketBrokers_Delete_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_NetworkPacketBrokersDeleteMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/NetworkPacketBrokers_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "NetworkPacketBrokers_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkPacketBrokerResource created on azure
            // for more information of creating NetworkPacketBrokerResource, please refer to the document of NetworkPacketBrokerResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string resourceGroupName = "example-rg";
            string networkPacketBrokerName = "example-networkPacketBroker";
            ResourceIdentifier networkPacketBrokerResourceId = NetworkPacketBrokerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkPacketBrokerName);
            NetworkPacketBrokerResource networkPacketBroker = client.GetNetworkPacketBrokerResource(networkPacketBrokerResourceId);

            // invoke the operation
            await networkPacketBroker.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // NetworkPacketBrokers_ListBySubscription_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNetworkPacketBrokers_NetworkPacketBrokersListBySubscriptionMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/NetworkPacketBrokers_ListBySubscription_MaximumSet_Gen.json
            // this example is just showing the usage of "NetworkPacketBrokers_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (NetworkPacketBrokerResource item in subscriptionResource.GetNetworkPacketBrokersAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkPacketBrokerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
