// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ManagedNetworkFabric.Samples
{
    public partial class Sample_NetworkFabricSkuResource
    {
        // NetworkFabricSkus_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_NetworkFabricSkusGetMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/NetworkFabricSkus_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "NetworkFabricSkus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkFabricSkuResource created on azure
            // for more information of creating NetworkFabricSkuResource, please refer to the document of NetworkFabricSkuResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string networkFabricSkuName = "example-fabricsku";
            ResourceIdentifier networkFabricSkuResourceId = NetworkFabricSkuResource.CreateResourceIdentifier(subscriptionId, networkFabricSkuName);
            NetworkFabricSkuResource networkFabricSku = client.GetNetworkFabricSkuResource(networkFabricSkuResourceId);

            // invoke the operation
            NetworkFabricSkuResource result = await networkFabricSku.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkFabricSkuData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
