// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ManagedNetworkFabric.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ManagedNetworkFabric.Samples
{
    public partial class Sample_NetworkFabricIPCommunityResource
    {
        // IpCommunities_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_IpCommunitiesGetMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "IpCommunities_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkFabricIPCommunityResource created on azure
            // for more information of creating NetworkFabricIPCommunityResource, please refer to the document of NetworkFabricIPCommunityResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string resourceGroupName = "example-rg";
            string ipCommunityName = "example-ipcommunity";
            ResourceIdentifier networkFabricIPCommunityResourceId = NetworkFabricIPCommunityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ipCommunityName);
            NetworkFabricIPCommunityResource networkFabricIPCommunity = client.GetNetworkFabricIPCommunityResource(networkFabricIPCommunityResourceId);

            // invoke the operation
            NetworkFabricIPCommunityResource result = await networkFabricIPCommunity.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkFabricIPCommunityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // IpCommunities_Update_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_IpCommunitiesUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Update_MaximumSet_Gen.json
            // this example is just showing the usage of "IpCommunities_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkFabricIPCommunityResource created on azure
            // for more information of creating NetworkFabricIPCommunityResource, please refer to the document of NetworkFabricIPCommunityResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string resourceGroupName = "example-rg";
            string ipCommunityName = "example-ipcommunity";
            ResourceIdentifier networkFabricIPCommunityResourceId = NetworkFabricIPCommunityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ipCommunityName);
            NetworkFabricIPCommunityResource networkFabricIPCommunity = client.GetNetworkFabricIPCommunityResource(networkFabricIPCommunityResourceId);

            // invoke the operation
            NetworkFabricIPCommunityPatch patch = new NetworkFabricIPCommunityPatch()
            {
                IPCommunityRules =
{
new IPCommunityRule(CommunityActionType.Permit,4155123341L,new string[]
{
"1:1"
})
{
WellKnownCommunities =
{
WellKnownCommunity.Internet
},
}
},
            };
            ArmOperation<NetworkFabricIPCommunityResource> lro = await networkFabricIPCommunity.UpdateAsync(WaitUntil.Completed, patch);
            NetworkFabricIPCommunityResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkFabricIPCommunityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // IpCommunities_Delete_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_IpCommunitiesDeleteMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "IpCommunities_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkFabricIPCommunityResource created on azure
            // for more information of creating NetworkFabricIPCommunityResource, please refer to the document of NetworkFabricIPCommunityResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            string resourceGroupName = "example-rg";
            string ipCommunityName = "example-ipcommunity";
            ResourceIdentifier networkFabricIPCommunityResourceId = NetworkFabricIPCommunityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ipCommunityName);
            NetworkFabricIPCommunityResource networkFabricIPCommunity = client.GetNetworkFabricIPCommunityResource(networkFabricIPCommunityResourceId);

            // invoke the operation
            await networkFabricIPCommunity.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // IpCommunities_ListBySubscription_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNetworkFabricIPCommunities_IpCommunitiesListBySubscriptionMaximumSetGen()
        {
            // Generated from example definition: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_ListBySubscription_MaximumSet_Gen.json
            // this example is just showing the usage of "IpCommunities_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "1234ABCD-0A1B-1234-5678-123456ABCDEF";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (NetworkFabricIPCommunityResource item in subscriptionResource.GetNetworkFabricIPCommunitiesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkFabricIPCommunityData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
