// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ManagedNetwork.Models
{
    /// <summary> Scope of a Managed Network. </summary>
    public partial class Scope
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="Scope"/>. </summary>
        public Scope()
        {
            ManagementGroups = new ChangeTrackingList<WritableSubResource>();
            Subscriptions = new ChangeTrackingList<WritableSubResource>();
            VirtualNetworks = new ChangeTrackingList<WritableSubResource>();
            Subnets = new ChangeTrackingList<WritableSubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="Scope"/>. </summary>
        /// <param name="managementGroups"> The collection of management groups covered by the Managed Network. </param>
        /// <param name="subscriptions"> The collection of subscriptions covered by the Managed Network. </param>
        /// <param name="virtualNetworks"> The collection of virtual nets covered by the Managed Network. </param>
        /// <param name="subnets"> The collection of  subnets covered by the Managed Network. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal Scope(IList<WritableSubResource> managementGroups, IList<WritableSubResource> subscriptions, IList<WritableSubResource> virtualNetworks, IList<WritableSubResource> subnets, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ManagementGroups = managementGroups;
            Subscriptions = subscriptions;
            VirtualNetworks = virtualNetworks;
            Subnets = subnets;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The collection of management groups covered by the Managed Network. </summary>
        public IList<WritableSubResource> ManagementGroups { get; }
        /// <summary> The collection of subscriptions covered by the Managed Network. </summary>
        public IList<WritableSubResource> Subscriptions { get; }
        /// <summary> The collection of virtual nets covered by the Managed Network. </summary>
        public IList<WritableSubResource> VirtualNetworks { get; }
        /// <summary> The collection of  subnets covered by the Managed Network. </summary>
        public IList<WritableSubResource> Subnets { get; }
    }
}
