// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagedNetwork.Models
{
    /// <summary> Responsibility role under which this Managed Network Group will be created. </summary>
    public readonly partial struct ManagedNetworkKind : IEquatable<ManagedNetworkKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedNetworkKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConnectivityValue = "Connectivity";

        /// <summary> Connectivity. </summary>
        public static ManagedNetworkKind Connectivity { get; } = new ManagedNetworkKind(ConnectivityValue);
        /// <summary> Determines if two <see cref="ManagedNetworkKind"/> values are the same. </summary>
        public static bool operator ==(ManagedNetworkKind left, ManagedNetworkKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedNetworkKind"/> values are not the same. </summary>
        public static bool operator !=(ManagedNetworkKind left, ManagedNetworkKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedNetworkKind"/>. </summary>
        public static implicit operator ManagedNetworkKind(string value) => new ManagedNetworkKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedNetworkKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedNetworkKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
