// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ManagedNetwork.Models
{
    /// <summary> The collection of Connectivity related groups and policies within the Managed Network. </summary>
    public partial class ConnectivityCollection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityCollection"/>. </summary>
        internal ConnectivityCollection()
        {
            Groups = new ChangeTrackingList<ManagedNetworkGroupData>();
            Peerings = new ChangeTrackingList<ManagedNetworkPeeringPolicyData>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityCollection"/>. </summary>
        /// <param name="groups"> The collection of connectivity related Managed Network Groups within the Managed Network. </param>
        /// <param name="peerings"> The collection of Managed Network Peering Policies within the Managed Network. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityCollection(IReadOnlyList<ManagedNetworkGroupData> groups, IReadOnlyList<ManagedNetworkPeeringPolicyData> peerings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Groups = groups;
            Peerings = peerings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The collection of connectivity related Managed Network Groups within the Managed Network. </summary>
        public IReadOnlyList<ManagedNetworkGroupData> Groups { get; }
        /// <summary> The collection of Managed Network Peering Policies within the Managed Network. </summary>
        public IReadOnlyList<ManagedNetworkPeeringPolicyData> Peerings { get; }
    }
}
