// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ManagedNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="ManagedNetworkResource"/> and their operations.
    /// Each <see cref="ManagedNetworkResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="ManagedNetworkCollection"/> instance call the GetManagedNetworks method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class ManagedNetworkCollection : ArmCollection, IEnumerable<ManagedNetworkResource>, IAsyncEnumerable<ManagedNetworkResource>
    {
        private readonly ClientDiagnostics _managedNetworkClientDiagnostics;
        private readonly ManagedNetworksRestOperations _managedNetworkRestClient;

        /// <summary> Initializes a new instance of the <see cref="ManagedNetworkCollection"/> class for mocking. </summary>
        protected ManagedNetworkCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ManagedNetworkCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ManagedNetworkCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _managedNetworkClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ManagedNetwork", ManagedNetworkResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ManagedNetworkResource.ResourceType, out string managedNetworkApiVersion);
            _managedNetworkRestClient = new ManagedNetworksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, managedNetworkApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// The Put ManagedNetworks operation creates/updates a Managed Network Resource, specified by resource group and Managed Network name
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="data"> Parameters supplied to the create/update a Managed Network Resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ManagedNetworkResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string managedNetworkName, ManagedNetworkData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _managedNetworkRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, data, cancellationToken).ConfigureAwait(false);
                var uri = _managedNetworkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ManagedNetworkArmOperation<ManagedNetworkResource>(Response.FromValue(new ManagedNetworkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The Put ManagedNetworks operation creates/updates a Managed Network Resource, specified by resource group and Managed Network name
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="data"> Parameters supplied to the create/update a Managed Network Resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ManagedNetworkResource> CreateOrUpdate(WaitUntil waitUntil, string managedNetworkName, ManagedNetworkData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _managedNetworkRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, data, cancellationToken);
                var uri = _managedNetworkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ManagedNetworkArmOperation<ManagedNetworkResource>(Response.FromValue(new ManagedNetworkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The Get ManagedNetworks operation gets a Managed Network Resource, specified by the resource group and Managed Network name
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        public virtual async Task<Response<ManagedNetworkResource>> GetAsync(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.Get");
            scope.Start();
            try
            {
                var response = await _managedNetworkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ManagedNetworkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The Get ManagedNetworks operation gets a Managed Network Resource, specified by the resource group and Managed Network name
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        public virtual Response<ManagedNetworkResource> Get(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.Get");
            scope.Start();
            try
            {
                var response = _managedNetworkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ManagedNetworkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The ListByResourceGroup ManagedNetwork operation retrieves all the Managed Network resources in a resource group in a paginated format.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> May be used to limit the number of results in a page for list queries. </param>
        /// <param name="skiptoken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ManagedNetworkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ManagedNetworkResource> GetAllAsync(int? top = null, string skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _managedNetworkRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, top, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _managedNetworkRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, top, skiptoken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ManagedNetworkResource(Client, ManagedNetworkData.DeserializeManagedNetworkData(e)), _managedNetworkClientDiagnostics, Pipeline, "ManagedNetworkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// The ListByResourceGroup ManagedNetwork operation retrieves all the Managed Network resources in a resource group in a paginated format.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> May be used to limit the number of results in a page for list queries. </param>
        /// <param name="skiptoken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ManagedNetworkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ManagedNetworkResource> GetAll(int? top = null, string skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _managedNetworkRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, top, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _managedNetworkRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, top, skiptoken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ManagedNetworkResource(Client, ManagedNetworkData.DeserializeManagedNetworkData(e)), _managedNetworkClientDiagnostics, Pipeline, "ManagedNetworkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.Exists");
            scope.Start();
            try
            {
                var response = await _managedNetworkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        public virtual Response<bool> Exists(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.Exists");
            scope.Start();
            try
            {
                var response = _managedNetworkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        public virtual async Task<NullableResponse<ManagedNetworkResource>> GetIfExistsAsync(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _managedNetworkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ManagedNetworkResource>(response.GetRawResponse());
                return Response.FromValue(new ManagedNetworkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        public virtual NullableResponse<ManagedNetworkResource> GetIfExists(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(managedNetworkName, nameof(managedNetworkName));

            using var scope = _managedNetworkClientDiagnostics.CreateScope("ManagedNetworkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _managedNetworkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, managedNetworkName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ManagedNetworkResource>(response.GetRawResponse());
                return Response.FromValue(new ManagedNetworkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ManagedNetworkResource> IEnumerable<ManagedNetworkResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ManagedNetworkResource> IAsyncEnumerable<ManagedNetworkResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
