// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetwork
{
    internal class ManagedNetworkPeeringPolicyOperationSource : IOperationSource<ManagedNetworkPeeringPolicyResource>
    {
        private readonly ArmClient _client;

        internal ManagedNetworkPeeringPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedNetworkPeeringPolicyResource IOperationSource<ManagedNetworkPeeringPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedNetworkPeeringPolicyData.DeserializeManagedNetworkPeeringPolicyData(document.RootElement);
            return new ManagedNetworkPeeringPolicyResource(_client, data);
        }

        async ValueTask<ManagedNetworkPeeringPolicyResource> IOperationSource<ManagedNetworkPeeringPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedNetworkPeeringPolicyData.DeserializeManagedNetworkPeeringPolicyData(document.RootElement);
            return new ManagedNetworkPeeringPolicyResource(_client, data);
        }
    }
}
