// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetwork
{
    internal class ManagedNetworkGroupOperationSource : IOperationSource<ManagedNetworkGroupResource>
    {
        private readonly ArmClient _client;

        internal ManagedNetworkGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedNetworkGroupResource IOperationSource<ManagedNetworkGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedNetworkGroupData.DeserializeManagedNetworkGroupData(document.RootElement);
            return new ManagedNetworkGroupResource(_client, data);
        }

        async ValueTask<ManagedNetworkGroupResource> IOperationSource<ManagedNetworkGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedNetworkGroupData.DeserializeManagedNetworkGroupData(document.RootElement);
            return new ManagedNetworkGroupResource(_client, data);
        }
    }
}
