// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetwork.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableManagedNetworkResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableManagedNetworkResourceGroupResource"/> class for mocking. </summary>
        protected MockableManagedNetworkResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableManagedNetworkResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableManagedNetworkResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of ManagedNetworkResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of ManagedNetworkResources and their operations over a ManagedNetworkResource. </returns>
        public virtual ManagedNetworkCollection GetManagedNetworks()
        {
            return GetCachedClient(client => new ManagedNetworkCollection(client, Id));
        }

        /// <summary>
        /// The Get ManagedNetworks operation gets a Managed Network Resource, specified by the resource group and Managed Network name
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ManagedNetworkResource>> GetManagedNetworkAsync(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            return await GetManagedNetworks().GetAsync(managedNetworkName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// The Get ManagedNetworks operation gets a Managed Network Resource, specified by the resource group and Managed Network name
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedNetworks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedNetworkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="managedNetworkName"> The name of the Managed Network. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="managedNetworkName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="managedNetworkName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ManagedNetworkResource> GetManagedNetwork(string managedNetworkName, CancellationToken cancellationToken = default)
        {
            return GetManagedNetworks().Get(managedNetworkName, cancellationToken);
        }
    }
}
