// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ManagedNetwork.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableManagedNetworkArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableManagedNetworkArmClient"/> class for mocking. </summary>
        protected MockableManagedNetworkArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableManagedNetworkArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableManagedNetworkArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableManagedNetworkArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of ScopeAssignmentResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of ScopeAssignmentResources and their operations over a ScopeAssignmentResource. </returns>
        public virtual ScopeAssignmentCollection GetScopeAssignments(ResourceIdentifier scope)
        {
            return new ScopeAssignmentCollection(Client, scope);
        }

        /// <summary>
        /// Get the specified scope assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.ManagedNetwork/scopeAssignments/{scopeAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopeAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScopeAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="scopeAssignmentName"> The name of the scope assignment to get. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scopeAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scopeAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ScopeAssignmentResource>> GetScopeAssignmentAsync(ResourceIdentifier scope, string scopeAssignmentName, CancellationToken cancellationToken = default)
        {
            return await GetScopeAssignments(scope).GetAsync(scopeAssignmentName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the specified scope assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.ManagedNetwork/scopeAssignments/{scopeAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopeAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ScopeAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="scopeAssignmentName"> The name of the scope assignment to get. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scopeAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scopeAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ScopeAssignmentResource> GetScopeAssignment(ResourceIdentifier scope, string scopeAssignmentName, CancellationToken cancellationToken = default)
        {
            return GetScopeAssignments(scope).Get(scopeAssignmentName, cancellationToken);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedNetworkResource.CreateResourceIdentifier" /> to create a <see cref="ManagedNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedNetworkResource"/> object. </returns>
        public virtual ManagedNetworkResource GetManagedNetworkResource(ResourceIdentifier id)
        {
            ManagedNetworkResource.ValidateResourceId(id);
            return new ManagedNetworkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ScopeAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ScopeAssignmentResource.CreateResourceIdentifier" /> to create a <see cref="ScopeAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ScopeAssignmentResource"/> object. </returns>
        public virtual ScopeAssignmentResource GetScopeAssignmentResource(ResourceIdentifier id)
        {
            ScopeAssignmentResource.ValidateResourceId(id);
            return new ScopeAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedNetworkGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedNetworkGroupResource.CreateResourceIdentifier" /> to create a <see cref="ManagedNetworkGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedNetworkGroupResource"/> object. </returns>
        public virtual ManagedNetworkGroupResource GetManagedNetworkGroupResource(ResourceIdentifier id)
        {
            ManagedNetworkGroupResource.ValidateResourceId(id);
            return new ManagedNetworkGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedNetworkPeeringPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedNetworkPeeringPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedNetworkPeeringPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedNetworkPeeringPolicyResource"/> object. </returns>
        public virtual ManagedNetworkPeeringPolicyResource GetManagedNetworkPeeringPolicyResource(ResourceIdentifier id)
        {
            ManagedNetworkPeeringPolicyResource.ValidateResourceId(id);
            return new ManagedNetworkPeeringPolicyResource(Client, id);
        }
    }
}
