// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ManagedNetwork.Samples
{
    public partial class Sample_ManagedNetworkGroupCollection
    {
        // ManagementNetworkGroupsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ManagementNetworkGroupsGet()
        {
            // Generated from example definition: specification/managednetwork/resource-manager/Microsoft.ManagedNetwork/preview/2019-06-01-preview/examples/ManagedNetworkGroup/ManagedNetworkGroupsGet.json
            // this example is just showing the usage of "ManagedNetworkGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedNetworkResource created on azure
            // for more information of creating ManagedNetworkResource, please refer to the document of ManagedNetworkResource
            string subscriptionId = "subscriptionA";
            string resourceGroupName = "myResourceGroup";
            string managedNetworkName = "myManagedNetwork";
            ResourceIdentifier managedNetworkResourceId = ManagedNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedNetworkName);
            ManagedNetworkResource managedNetwork = client.GetManagedNetworkResource(managedNetworkResourceId);

            // get the collection of this ManagedNetworkGroupResource
            ManagedNetworkGroupCollection collection = managedNetwork.GetManagedNetworkGroups();

            // invoke the operation
            string managedNetworkGroupName = "myManagedNetworkGroup1";
            ManagedNetworkGroupResource result = await collection.GetAsync(managedNetworkGroupName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedNetworkGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ManagementNetworkGroupsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ManagementNetworkGroupsGet()
        {
            // Generated from example definition: specification/managednetwork/resource-manager/Microsoft.ManagedNetwork/preview/2019-06-01-preview/examples/ManagedNetworkGroup/ManagedNetworkGroupsGet.json
            // this example is just showing the usage of "ManagedNetworkGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedNetworkResource created on azure
            // for more information of creating ManagedNetworkResource, please refer to the document of ManagedNetworkResource
            string subscriptionId = "subscriptionA";
            string resourceGroupName = "myResourceGroup";
            string managedNetworkName = "myManagedNetwork";
            ResourceIdentifier managedNetworkResourceId = ManagedNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedNetworkName);
            ManagedNetworkResource managedNetwork = client.GetManagedNetworkResource(managedNetworkResourceId);

            // get the collection of this ManagedNetworkGroupResource
            ManagedNetworkGroupCollection collection = managedNetwork.GetManagedNetworkGroups();

            // invoke the operation
            string managedNetworkGroupName = "myManagedNetworkGroup1";
            bool result = await collection.ExistsAsync(managedNetworkGroupName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ManagementNetworkGroupsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ManagementNetworkGroupsGet()
        {
            // Generated from example definition: specification/managednetwork/resource-manager/Microsoft.ManagedNetwork/preview/2019-06-01-preview/examples/ManagedNetworkGroup/ManagedNetworkGroupsGet.json
            // this example is just showing the usage of "ManagedNetworkGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedNetworkResource created on azure
            // for more information of creating ManagedNetworkResource, please refer to the document of ManagedNetworkResource
            string subscriptionId = "subscriptionA";
            string resourceGroupName = "myResourceGroup";
            string managedNetworkName = "myManagedNetwork";
            ResourceIdentifier managedNetworkResourceId = ManagedNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedNetworkName);
            ManagedNetworkResource managedNetwork = client.GetManagedNetworkResource(managedNetworkResourceId);

            // get the collection of this ManagedNetworkGroupResource
            ManagedNetworkGroupCollection collection = managedNetwork.GetManagedNetworkGroups();

            // invoke the operation
            string managedNetworkGroupName = "myManagedNetworkGroup1";
            NullableResponse<ManagedNetworkGroupResource> response = await collection.GetIfExistsAsync(managedNetworkGroupName);
            ManagedNetworkGroupResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ManagedNetworkGroupData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // ManagementNetworkGroupsPut
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ManagementNetworkGroupsPut()
        {
            // Generated from example definition: specification/managednetwork/resource-manager/Microsoft.ManagedNetwork/preview/2019-06-01-preview/examples/ManagedNetworkGroup/ManagedNetworkGroupsPut.json
            // this example is just showing the usage of "ManagedNetworkGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedNetworkResource created on azure
            // for more information of creating ManagedNetworkResource, please refer to the document of ManagedNetworkResource
            string subscriptionId = "subscriptionA";
            string resourceGroupName = "myResourceGroup";
            string managedNetworkName = "myManagedNetwork";
            ResourceIdentifier managedNetworkResourceId = ManagedNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedNetworkName);
            ManagedNetworkResource managedNetwork = client.GetManagedNetworkResource(managedNetworkResourceId);

            // get the collection of this ManagedNetworkGroupResource
            ManagedNetworkGroupCollection collection = managedNetwork.GetManagedNetworkGroups();

            // invoke the operation
            string managedNetworkGroupName = "myManagedNetworkGroup1";
            ManagedNetworkGroupData data = new ManagedNetworkGroupData()
            {
                ManagementGroups =
{
},
                Subscriptions =
{
},
                VirtualNetworks =
{
new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
},new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"),
}
},
                Subnets =
{
new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA"),
}
},
            };
            ArmOperation<ManagedNetworkGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, managedNetworkGroupName, data);
            ManagedNetworkGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedNetworkGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ManagedNetworksGroupsListByManagedNetwork
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ManagedNetworksGroupsListByManagedNetwork()
        {
            // Generated from example definition: specification/managednetwork/resource-manager/Microsoft.ManagedNetwork/preview/2019-06-01-preview/examples/ManagedNetworkGroup/ManagedNetworkGroupsListByManagedNetwork.json
            // this example is just showing the usage of "ManagedNetworkGroups_ListByManagedNetwork" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedNetworkResource created on azure
            // for more information of creating ManagedNetworkResource, please refer to the document of ManagedNetworkResource
            string subscriptionId = "subscriptionA";
            string resourceGroupName = "myResourceGroup";
            string managedNetworkName = "myManagedNetwork";
            ResourceIdentifier managedNetworkResourceId = ManagedNetworkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedNetworkName);
            ManagedNetworkResource managedNetwork = client.GetManagedNetworkResource(managedNetworkResourceId);

            // get the collection of this ManagedNetworkGroupResource
            ManagedNetworkGroupCollection collection = managedNetwork.GetManagedNetworkGroups();

            // invoke the operation and iterate over the result
            await foreach (ManagedNetworkGroupResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ManagedNetworkGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
