// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Maintenance.Models
{
    internal static partial class VmTagOperatorExtensions
    {
        public static string ToSerialString(this VmTagOperator value) => value switch
        {
            VmTagOperator.All => "All",
            VmTagOperator.Any => "Any",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown VmTagOperator value.")
        };

        public static VmTagOperator ToVmTagOperator(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "All")) return VmTagOperator.All;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Any")) return VmTagOperator.Any;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown VmTagOperator value.");
        }
    }
}
