// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Maintenance.Models
{
    /// <summary> The status. </summary>
    public readonly partial struct MaintenanceUpdateStatus : IEquatable<MaintenanceUpdateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MaintenanceUpdateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MaintenanceUpdateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string InProgressValue = "InProgress";
        private const string CompletedValue = "Completed";
        private const string RetryNowValue = "RetryNow";
        private const string RetryLaterValue = "RetryLater";
        private const string NoUpdatesPendingValue = "NoUpdatesPending";
        private const string CancelValue = "Cancel";
        private const string CancelledValue = "Cancelled";

        /// <summary> There are pending updates to be installed. </summary>
        public static MaintenanceUpdateStatus Pending { get; } = new MaintenanceUpdateStatus(PendingValue);
        /// <summary> Updates installation are in progress. </summary>
        public static MaintenanceUpdateStatus InProgress { get; } = new MaintenanceUpdateStatus(InProgressValue);
        /// <summary> All updates are successfully applied. </summary>
        public static MaintenanceUpdateStatus Completed { get; } = new MaintenanceUpdateStatus(CompletedValue);
        /// <summary> Updates installation failed but are ready to retry again. </summary>
        public static MaintenanceUpdateStatus RetryNow { get; } = new MaintenanceUpdateStatus(RetryNowValue);
        /// <summary> Updates installation failed and should be retried later. </summary>
        public static MaintenanceUpdateStatus RetryLater { get; } = new MaintenanceUpdateStatus(RetryLaterValue);
        /// <summary> No updates are pending. </summary>
        public static MaintenanceUpdateStatus NoUpdatesPending { get; } = new MaintenanceUpdateStatus(NoUpdatesPendingValue);
        /// <summary> Cancel the schedule and stop creating PMR for resources part of it. Applicable to Maintenance Configuration resource type only. </summary>
        public static MaintenanceUpdateStatus Cancel { get; } = new MaintenanceUpdateStatus(CancelValue);
        /// <summary> Send the Cancelled response to the user if request came to cancel the schedule. Applicable to Maintenance Configuration resource type only. </summary>
        public static MaintenanceUpdateStatus Cancelled { get; } = new MaintenanceUpdateStatus(CancelledValue);
        /// <summary> Determines if two <see cref="MaintenanceUpdateStatus"/> values are the same. </summary>
        public static bool operator ==(MaintenanceUpdateStatus left, MaintenanceUpdateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MaintenanceUpdateStatus"/> values are not the same. </summary>
        public static bool operator !=(MaintenanceUpdateStatus left, MaintenanceUpdateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MaintenanceUpdateStatus"/>. </summary>
        public static implicit operator MaintenanceUpdateStatus(string value) => new MaintenanceUpdateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MaintenanceUpdateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MaintenanceUpdateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
