// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Maintenance.Models
{
    /// <summary> Maintenance update on a resource. </summary>
    public partial class MaintenanceUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MaintenanceUpdate"/>. </summary>
        internal MaintenanceUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MaintenanceUpdate"/>. </summary>
        /// <param name="maintenanceScope"> The impact area. </param>
        /// <param name="impactType"> The impact type. </param>
        /// <param name="status"> The status. </param>
        /// <param name="impactDurationInSec"> Duration of impact in seconds. </param>
        /// <param name="notBefore"> Time when Azure will start force updates if not self-updated by customer before this time. </param>
        /// <param name="resourceId"> The resourceId. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MaintenanceUpdate(MaintenanceScope? maintenanceScope, MaintenanceImpactType? impactType, MaintenanceUpdateStatus? status, int? impactDurationInSec, DateTimeOffset? notBefore, ResourceIdentifier resourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaintenanceScope = maintenanceScope;
            ImpactType = impactType;
            Status = status;
            ImpactDurationInSec = impactDurationInSec;
            NotBefore = notBefore;
            ResourceId = resourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The impact area. </summary>
        public MaintenanceScope? MaintenanceScope { get; }
        /// <summary> The impact type. </summary>
        public MaintenanceImpactType? ImpactType { get; }
        /// <summary> The status. </summary>
        public MaintenanceUpdateStatus? Status { get; }
        /// <summary> Duration of impact in seconds. </summary>
        public int? ImpactDurationInSec { get; }
        /// <summary> Time when Azure will start force updates if not self-updated by customer before this time. </summary>
        public DateTimeOffset? NotBefore { get; }
        /// <summary> The resourceId. </summary>
        public ResourceIdentifier ResourceId { get; }
    }
}
