// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Maintenance.Models
{
    /// <summary> Gets or sets the visibility of the configuration. The default value is 'Custom'. </summary>
    public readonly partial struct MaintenanceConfigurationVisibility : IEquatable<MaintenanceConfigurationVisibility>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MaintenanceConfigurationVisibility"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MaintenanceConfigurationVisibility(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomValue = "Custom";
        private const string PublicValue = "Public";

        /// <summary> Only visible to users with permissions. </summary>
        public static MaintenanceConfigurationVisibility Custom { get; } = new MaintenanceConfigurationVisibility(CustomValue);
        /// <summary> Visible to all users. </summary>
        public static MaintenanceConfigurationVisibility Public { get; } = new MaintenanceConfigurationVisibility(PublicValue);
        /// <summary> Determines if two <see cref="MaintenanceConfigurationVisibility"/> values are the same. </summary>
        public static bool operator ==(MaintenanceConfigurationVisibility left, MaintenanceConfigurationVisibility right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MaintenanceConfigurationVisibility"/> values are not the same. </summary>
        public static bool operator !=(MaintenanceConfigurationVisibility left, MaintenanceConfigurationVisibility right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MaintenanceConfigurationVisibility"/>. </summary>
        public static implicit operator MaintenanceConfigurationVisibility(string value) => new MaintenanceConfigurationVisibility(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MaintenanceConfigurationVisibility other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MaintenanceConfigurationVisibility other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
