// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Maintenance.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Maintenance.Samples
{
    public partial class Sample_SubscriptionResourceExtensions
    {
        // ConfigurationAssignmentsResultWithinSubscription_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetConfigurationAssignmentsBySubscription_ConfigurationAssignmentsResultWithinSubscriptionList()
        {
            // Generated from example definition: specification/maintenance/resource-manager/Microsoft.Maintenance/preview/2023-10-01-preview/examples/ConfigurationAssignmentsResultWithinSubscription_List.json
            // this example is just showing the usage of "ConfigurationAssignmentsWithinSubscription_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (MaintenanceConfigurationAssignmentData item in subscriptionResource.GetConfigurationAssignmentsBySubscriptionAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ConfigurationAssignments_GetParent
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetConfigurationAssignmentBySubscription_ConfigurationAssignmentsGetParent()
        {
            // Generated from example definition: specification/maintenance/resource-manager/Microsoft.Maintenance/preview/2023-10-01-preview/examples/ConfigurationAssignmentsForSubscriptions_Get.json
            // this example is just showing the usage of "ConfigurationAssignmentsForSubscriptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            string configurationAssignmentName = "workervmConfiguration";
            MaintenanceConfigurationAssignmentData result = await subscriptionResource.GetConfigurationAssignmentBySubscriptionAsync(configurationAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ConfigurationAssignmentsForSubscriptions_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdateConfigurationAssignmentBySubscription_ConfigurationAssignmentsForSubscriptionsCreateOrUpdate()
        {
            // Generated from example definition: specification/maintenance/resource-manager/Microsoft.Maintenance/preview/2023-10-01-preview/examples/ConfigurationAssignmentsForSubscriptions_CreateOrUpdate.json
            // this example is just showing the usage of "ConfigurationAssignmentsForSubscriptions_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            string configurationAssignmentName = "workervmConfiguration";
            MaintenanceConfigurationAssignmentData data = new MaintenanceConfigurationAssignmentData()
            {
                MaintenanceConfigurationId = new ResourceIdentifier("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
                Filter = new MaintenanceConfigurationAssignmentFilter()
                {
                    ResourceTypes =
{
new ResourceType("Microsoft.HybridCompute/machines"),new ResourceType("Microsoft.Compute/virtualMachines")
},
                    ResourceGroups =
{
"RG1","RG2"
},
                    Locations =
{
new AzureLocation("Japan East"),new AzureLocation("UK South")
},
                    TagSettings = new VmTagSettings()
                    {
                        Tags =
{
["tag1"] = new string[]
{
"tag1Value1","tag1Value2","tag1Value3"
},
["tag2"] = new string[]
{
"tag2Value1","tag2Value2","tag2Value3"
},
},
                        FilterOperator = VmTagOperator.Any,
                    },
                },
            };
            MaintenanceConfigurationAssignmentData result = await subscriptionResource.CreateOrUpdateConfigurationAssignmentBySubscriptionAsync(configurationAssignmentName, data);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ConfigurationAssignmentsForSubscriptions_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateConfigurationAssignmentBySubscription_ConfigurationAssignmentsForSubscriptionsCreateOrUpdate()
        {
            // Generated from example definition: specification/maintenance/resource-manager/Microsoft.Maintenance/preview/2023-10-01-preview/examples/ConfigurationAssignmentsForSubscriptions_UpdateForResource.json
            // this example is just showing the usage of "ConfigurationAssignmentsForSubscriptions_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            string configurationAssignmentName = "workervmConfiguration";
            MaintenanceConfigurationAssignmentData data = new MaintenanceConfigurationAssignmentData()
            {
                MaintenanceConfigurationId = new ResourceIdentifier("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
                Filter = new MaintenanceConfigurationAssignmentFilter()
                {
                    ResourceTypes =
{
new ResourceType("Microsoft.HybridCompute/machines"),new ResourceType("Microsoft.Compute/virtualMachines")
},
                    ResourceGroups =
{
"RG1","RG2"
},
                    Locations =
{
new AzureLocation("Japan East"),new AzureLocation("UK South")
},
                    TagSettings = new VmTagSettings()
                    {
                        Tags =
{
["tag1"] = new string[]
{
"tag1Value1","tag1Value2","tag1Value3"
},
["tag2"] = new string[]
{
"tag2Value1","tag2Value2","tag2Value3"
},
},
                        FilterOperator = VmTagOperator.Any,
                    },
                },
            };
            MaintenanceConfigurationAssignmentData result = await subscriptionResource.UpdateConfigurationAssignmentBySubscriptionAsync(configurationAssignmentName, data);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ConfigurationAssignmentsForSubscriptions_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteConfigurationAssignmentBySubscription_ConfigurationAssignmentsForSubscriptionsDelete()
        {
            // Generated from example definition: specification/maintenance/resource-manager/Microsoft.Maintenance/preview/2023-10-01-preview/examples/ConfigurationAssignmentsForSubscriptions_Delete.json
            // this example is just showing the usage of "ConfigurationAssignmentsForSubscriptions_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            string configurationAssignmentName = "workervmConfiguration";
            MaintenanceConfigurationAssignmentData result = await subscriptionResource.DeleteConfigurationAssignmentBySubscriptionAsync(configurationAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
