// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> WorkspaceHub's configuration object. </summary>
    public partial class WorkspaceHubConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkspaceHubConfig"/>. </summary>
        public WorkspaceHubConfig()
        {
            AdditionalWorkspaceStorageAccounts = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkspaceHubConfig"/>. </summary>
        /// <param name="additionalWorkspaceStorageAccounts"></param>
        /// <param name="defaultWorkspaceResourceGroup"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkspaceHubConfig(IList<string> additionalWorkspaceStorageAccounts, string defaultWorkspaceResourceGroup, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AdditionalWorkspaceStorageAccounts = additionalWorkspaceStorageAccounts;
            DefaultWorkspaceResourceGroup = defaultWorkspaceResourceGroup;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the additional workspace storage accounts. </summary>
        [WirePath("additionalWorkspaceStorageAccounts")]
        public IList<string> AdditionalWorkspaceStorageAccounts { get; }
        /// <summary> Gets or sets the default workspace resource group. </summary>
        [WirePath("defaultWorkspaceResourceGroup")]
        public string DefaultWorkspaceResourceGroup { get; set; }
    }
}
