// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The WorkspaceConnectionServicePrincipal. </summary>
    public partial class WorkspaceConnectionServicePrincipal
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkspaceConnectionServicePrincipal"/>. </summary>
        public WorkspaceConnectionServicePrincipal()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WorkspaceConnectionServicePrincipal"/>. </summary>
        /// <param name="clientId"></param>
        /// <param name="clientSecret"></param>
        /// <param name="tenantId"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkspaceConnectionServicePrincipal(string clientId, string clientSecret, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientId = clientId;
            ClientSecret = clientSecret;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the client id. </summary>
        [WirePath("clientId")]
        public string ClientId { get; set; }
        /// <summary> Gets or sets the client secret. </summary>
        [WirePath("clientSecret")]
        public string ClientSecret { get; set; }
        /// <summary> Gets or sets the tenant id. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
    }
}
