// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary>
    /// ClientId and ClientSecret are required. Other properties are optional
    /// depending on each OAuth2 provider's implementation.
    /// </summary>
    public partial class WorkspaceConnectionOAuth2
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkspaceConnectionOAuth2"/>. </summary>
        public WorkspaceConnectionOAuth2()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WorkspaceConnectionOAuth2"/>. </summary>
        /// <param name="authUri"> Required by Concur connection category. </param>
        /// <param name="clientId"> Client id in the format of UUID. </param>
        /// <param name="clientSecret"></param>
        /// <param name="developerToken"> Required by GoogleAdWords connection category. </param>
        /// <param name="password"></param>
        /// <param name="refreshToken">
        /// Required by GoogleBigQuery, GoogleAdWords, Hubspot, QuickBooks, Square, Xero, Zoho
        /// where user needs to get RefreshToken offline
        /// </param>
        /// <param name="tenantId"> Required by QuickBooks and Xero connection categories. </param>
        /// <param name="username">
        /// Concur, ServiceNow auth server AccessToken grant type is 'Password'
        /// which requires UsernamePassword
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkspaceConnectionOAuth2(Uri authUri, Guid? clientId, string clientSecret, string developerToken, string password, string refreshToken, Guid? tenantId, string username, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthUri = authUri;
            ClientId = clientId;
            ClientSecret = clientSecret;
            DeveloperToken = developerToken;
            Password = password;
            RefreshToken = refreshToken;
            TenantId = tenantId;
            Username = username;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Required by Concur connection category. </summary>
        [WirePath("authUrl")]
        public Uri AuthUri { get; set; }
        /// <summary> Client id in the format of UUID. </summary>
        [WirePath("clientId")]
        public Guid? ClientId { get; set; }
        /// <summary> Gets or sets the client secret. </summary>
        [WirePath("clientSecret")]
        public string ClientSecret { get; set; }
        /// <summary> Required by GoogleAdWords connection category. </summary>
        [WirePath("developerToken")]
        public string DeveloperToken { get; set; }
        /// <summary> Gets or sets the password. </summary>
        [WirePath("password")]
        public string Password { get; set; }
        /// <summary>
        /// Required by GoogleBigQuery, GoogleAdWords, Hubspot, QuickBooks, Square, Xero, Zoho
        /// where user needs to get RefreshToken offline
        /// </summary>
        [WirePath("refreshToken")]
        public string RefreshToken { get; set; }
        /// <summary> Required by QuickBooks and Xero connection categories. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary>
        /// Concur, ServiceNow auth server AccessToken grant type is 'Password'
        /// which requires UsernamePassword
        /// </summary>
        [WirePath("username")]
        public string Username { get; set; }
    }
}
