// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Unknown version of AutoMLVertical. </summary>
    internal partial class UnknownAutoMLVertical : AutoMLVertical
    {
        /// <summary> Initializes a new instance of <see cref="UnknownAutoMLVertical"/>. </summary>
        /// <param name="taskType"> [Required] Task type for AutoMLJob. </param>
        /// <param name="logVerbosity"> Log verbosity for the job. </param>
        /// <param name="trainingData"> [Required] Training data input. </param>
        /// <param name="targetColumnName">
        /// Target column name: This is prediction values column.
        /// Also known as label column name in context of classification tasks.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownAutoMLVertical(TaskType taskType, MachineLearningLogVerbosity? logVerbosity, MachineLearningTableJobInput trainingData, string targetColumnName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(taskType, logVerbosity, trainingData, targetColumnName, serializedAdditionalRawData)
        {
            TaskType = taskType;
        }

        /// <summary> Initializes a new instance of <see cref="UnknownAutoMLVertical"/> for deserialization. </summary>
        internal UnknownAutoMLVertical()
        {
        }
    }
}
