// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The TriggerType. </summary>
    internal readonly partial struct TriggerType : IEquatable<TriggerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TriggerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TriggerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RecurrenceValue = "Recurrence";
        private const string CronValue = "Cron";

        /// <summary> Recurrence. </summary>
        public static TriggerType Recurrence { get; } = new TriggerType(RecurrenceValue);
        /// <summary> Cron. </summary>
        public static TriggerType Cron { get; } = new TriggerType(CronValue);
        /// <summary> Determines if two <see cref="TriggerType"/> values are the same. </summary>
        public static bool operator ==(TriggerType left, TriggerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TriggerType"/> values are not the same. </summary>
        public static bool operator !=(TriggerType left, TriggerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TriggerType"/>. </summary>
        public static implicit operator TriggerType(string value) => new TriggerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TriggerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TriggerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
