// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> AutoMLJob Task type. </summary>
    internal readonly partial struct TaskType : IEquatable<TaskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TaskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TaskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClassificationValue = "Classification";
        private const string RegressionValue = "Regression";
        private const string ForecastingValue = "Forecasting";
        private const string ImageClassificationValue = "ImageClassification";
        private const string ImageClassificationMultilabelValue = "ImageClassificationMultilabel";
        private const string ImageObjectDetectionValue = "ImageObjectDetection";
        private const string ImageInstanceSegmentationValue = "ImageInstanceSegmentation";
        private const string TextClassificationValue = "TextClassification";
        private const string TextClassificationMultilabelValue = "TextClassificationMultilabel";
        private const string TextNERValue = "TextNER";

        /// <summary>
        /// Classification in machine learning and statistics is a supervised learning approach in which
        /// the computer program learns from the data given to it and make new observations or classifications.
        /// </summary>
        public static TaskType Classification { get; } = new TaskType(ClassificationValue);
        /// <summary> Regression means to predict the value using the input data. Regression models are used to predict a continuous value. </summary>
        public static TaskType Regression { get; } = new TaskType(RegressionValue);
        /// <summary>
        /// Forecasting is a special kind of regression task that deals with time-series data and creates forecasting model
        /// that can be used to predict the near future values based on the inputs.
        /// </summary>
        public static TaskType Forecasting { get; } = new TaskType(ForecastingValue);
        /// <summary>
        /// Image Classification. Multi-class image classification is used when an image is classified with only a single label
        /// from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.
        /// </summary>
        public static TaskType ImageClassification { get; } = new TaskType(ImageClassificationValue);
        /// <summary>
        /// Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
        /// from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
        /// </summary>
        public static TaskType ImageClassificationMultilabel { get; } = new TaskType(ImageClassificationMultilabelValue);
        /// <summary>
        /// Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
        /// bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
        /// </summary>
        public static TaskType ImageObjectDetection { get; } = new TaskType(ImageObjectDetectionValue);
        /// <summary>
        /// Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
        /// drawing a polygon around each object in the image.
        /// </summary>
        public static TaskType ImageInstanceSegmentation { get; } = new TaskType(ImageInstanceSegmentationValue);
        /// <summary>
        /// Text classification (also known as text tagging or text categorization) is the process of sorting texts into categories.
        /// Categories are mutually exclusive.
        /// </summary>
        public static TaskType TextClassification { get; } = new TaskType(TextClassificationValue);
        /// <summary> Multilabel classification task assigns each sample to a group (zero or more) of target labels. </summary>
        public static TaskType TextClassificationMultilabel { get; } = new TaskType(TextClassificationMultilabelValue);
        /// <summary>
        /// Text Named Entity Recognition a.k.a. TextNER.
        /// Named Entity Recognition (NER) is the ability to take free-form text and identify the occurrences of entities such as people, locations, organizations, and more.
        /// </summary>
        public static TaskType TextNER { get; } = new TaskType(TextNERValue);
        /// <summary> Determines if two <see cref="TaskType"/> values are the same. </summary>
        public static bool operator ==(TaskType left, TaskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TaskType"/> values are not the same. </summary>
        public static bool operator !=(TaskType left, TaskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TaskType"/>. </summary>
        public static implicit operator TaskType(string value) => new TaskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TaskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TaskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
