// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The SystemCreatedAcrAccount. </summary>
    public partial class SystemCreatedAcrAccount
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SystemCreatedAcrAccount"/>. </summary>
        public SystemCreatedAcrAccount()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SystemCreatedAcrAccount"/>. </summary>
        /// <param name="acrAccountName"> Name of the ACR account. </param>
        /// <param name="acrAccountSku"> SKU of the ACR account. </param>
        /// <param name="armResourceIdentifier"> This is populated once the ACR account is created. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SystemCreatedAcrAccount(string acrAccountName, string acrAccountSku, ArmResourceId armResourceIdentifier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AcrAccountName = acrAccountName;
            AcrAccountSku = acrAccountSku;
            ArmResourceIdentifier = armResourceIdentifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the ACR account. </summary>
        [WirePath("acrAccountName")]
        public string AcrAccountName { get; set; }
        /// <summary> SKU of the ACR account. </summary>
        [WirePath("acrAccountSku")]
        public string AcrAccountSku { get; set; }
        /// <summary> This is populated once the ACR account is created. </summary>
        internal ArmResourceId ArmResourceIdentifier { get; set; }
        /// <summary>
        /// Arm ResourceId is in the format "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
        /// or "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}"
        /// </summary>
        [WirePath("armResourceId.resourceId")]
        public ResourceIdentifier ArmResourceId
        {
            get => ArmResourceIdentifier is null ? default : ArmResourceIdentifier.ResourceId;
            set
            {
                if (ArmResourceIdentifier is null)
                    ArmResourceIdentifier = new ArmResourceId();
                ArmResourceIdentifier.ResourceId = value;
            }
        }
    }
}
