// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class SystemCreatedAcrAccount : IUtf8JsonSerializable, IJsonModel<SystemCreatedAcrAccount>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SystemCreatedAcrAccount>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SystemCreatedAcrAccount>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SystemCreatedAcrAccount>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SystemCreatedAcrAccount)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AcrAccountName))
            {
                if (AcrAccountName != null)
                {
                    writer.WritePropertyName("acrAccountName"u8);
                    writer.WriteStringValue(AcrAccountName);
                }
                else
                {
                    writer.WriteNull("acrAccountName");
                }
            }
            if (Optional.IsDefined(AcrAccountSku))
            {
                if (AcrAccountSku != null)
                {
                    writer.WritePropertyName("acrAccountSku"u8);
                    writer.WriteStringValue(AcrAccountSku);
                }
                else
                {
                    writer.WriteNull("acrAccountSku");
                }
            }
            if (Optional.IsDefined(ArmResourceIdentifier))
            {
                if (ArmResourceIdentifier != null)
                {
                    writer.WritePropertyName("armResourceId"u8);
                    writer.WriteObjectValue(ArmResourceIdentifier, options);
                }
                else
                {
                    writer.WriteNull("armResourceId");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SystemCreatedAcrAccount IJsonModel<SystemCreatedAcrAccount>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SystemCreatedAcrAccount>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SystemCreatedAcrAccount)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSystemCreatedAcrAccount(document.RootElement, options);
        }

        internal static SystemCreatedAcrAccount DeserializeSystemCreatedAcrAccount(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string acrAccountName = default;
            string acrAccountSku = default;
            ArmResourceId armResourceId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("acrAccountName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        acrAccountName = null;
                        continue;
                    }
                    acrAccountName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("acrAccountSku"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        acrAccountSku = null;
                        continue;
                    }
                    acrAccountSku = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("armResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        armResourceId = null;
                        continue;
                    }
                    armResourceId = Models.ArmResourceId.DeserializeArmResourceId(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SystemCreatedAcrAccount(acrAccountName, acrAccountSku, armResourceId, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AcrAccountName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  acrAccountName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AcrAccountName))
                {
                    builder.Append("  acrAccountName: ");
                    if (AcrAccountName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AcrAccountName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AcrAccountName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AcrAccountSku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  acrAccountSku: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AcrAccountSku))
                {
                    builder.Append("  acrAccountSku: ");
                    if (AcrAccountSku.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AcrAccountSku}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AcrAccountSku}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("ArmResourceId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  armResourceId: ");
                builder.AppendLine("{");
                builder.Append("    resourceId: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ArmResourceIdentifier))
                {
                    builder.Append("  armResourceId: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ArmResourceIdentifier, options, 2, false, "  armResourceId: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SystemCreatedAcrAccount>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SystemCreatedAcrAccount>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SystemCreatedAcrAccount)} does not support writing '{options.Format}' format.");
            }
        }

        SystemCreatedAcrAccount IPersistableModel<SystemCreatedAcrAccount>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SystemCreatedAcrAccount>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSystemCreatedAcrAccount(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SystemCreatedAcrAccount)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SystemCreatedAcrAccount>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
